/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRepositoryItem;
import net.sf.robocode.repository.items.NamedItem;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.version.IVersionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamItem
extends NamedItem
implements IRepositoryItem {
    private static final long serialVersionUID = 1L;
    private static final String TEAM_DESCRIPTION = "team.description";
    private static final String TEAM_AUTHOR_NAME = "team.author.name";
    private static final String TEAM_AUTHOR_WEBSITE = "team.author.website";
    private static final String TEAM_VERSION = "team.version";
    private static final String TEAM_WEBPAGE = "team.webpage";
    private static final String TEAM_MEMBERS = "team.members";
    private static final String ROBOCODE_VERSION = "robocode.version";
    private final String teamFullName;

    public TeamItem(URL url, IRepositoryRoot root) {
        super(url, root);
        String tUrl = url.toString();
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(".team"));
        int versionSeparator = tUrl.lastIndexOf(" ");
        int rootLen = root.getRootUrl().toString().length();
        this.teamFullName = versionSeparator != -1 ? tUrl.substring(rootLen, versionSeparator).replace('/', '.').replace('\\', '.') : tUrl.substring(rootLen).replace('/', '.').replace('\\', '.');
        if (this.loadProperties()) {
            this.isValid = true;
        }
    }

    private void htmlUrlFromPropertiesUrl() {
        try {
            this.htmlUrl = new URL(this.url.toString().replaceAll("\\.team", ".html"));
            URLConnection conn = URLJarCollector.openConnection((URL)this.htmlUrl);
            conn.getInputStream().close();
        }
        catch (IOException ignored) {
            this.htmlUrl = null;
        }
    }

    @Override
    public List<String> getFriendlyUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        String tUrl = this.url.toString();
        urls.add(tUrl.substring(0, tUrl.lastIndexOf(46)));
        urls.add(this.url.getFile());
        urls.add(this.getFullClassName());
        urls.add(this.getUniqueFullClassNameWithVersion());
        return urls;
    }

    @Override
    public void update(long lastModified, boolean force) {
        if (lastModified > this.lastModified || force) {
            this.lastModified = lastModified;
            this.loadProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        if (this.url != null) {
            boolean bl;
            InputStream ios = null;
            try {
                URLConnection connection = URLJarCollector.openConnection((URL)this.url);
                ios = connection.getInputStream();
                this.properties.load(ios);
                bl = true;
            }
            catch (IOException e) {
                try {
                    Logger.logError((Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ios);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)ios);
            }
            FileUtil.cleanupStream((Object)ios);
            return bl;
        }
        return false;
    }

    @Override
    public URL getHtmlUrl() {
        if (this.htmlUrl == null) {
            this.htmlUrlFromPropertiesUrl();
        }
        return this.htmlUrl;
    }

    @Override
    public URL getPropertiesUrl() {
        return this.url;
    }

    public boolean isTeam() {
        return true;
    }

    @Override
    public String getFullClassName() {
        return this.teamFullName;
    }

    public String getMembers() {
        return this.properties.getProperty(TEAM_MEMBERS, null);
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty(TEAM_VERSION, null);
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty(TEAM_DESCRIPTION, null);
    }

    @Override
    public String getAuthorName() {
        return this.properties.getProperty(TEAM_AUTHOR_NAME, null);
    }

    @Override
    public URL getWebpage() {
        try {
            return new URL(this.properties.getProperty(TEAM_AUTHOR_WEBSITE, null));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean isJavaSourceIncluded() {
        return false;
    }

    @Override
    public String getRobocodeVersion() {
        return this.properties.getProperty(ROBOCODE_VERSION, null);
    }

    public String toString() {
        return this.url.toString();
    }

    public void storeProperties(OutputStream os) throws IOException {
        this.properties.store(os, "Robocode Robot Team");
    }

    public void storeProperties(OutputStream os, URL web, String desc, String author, String version) throws IOException {
        Properties copy = (Properties)this.properties.clone();
        if (version != null) {
            copy.setProperty(TEAM_VERSION, version);
        }
        if (desc != null) {
            copy.setProperty(TEAM_DESCRIPTION, desc);
        }
        if (author != null) {
            copy.setProperty(TEAM_AUTHOR_NAME, author);
        }
        if (web != null) {
            copy.setProperty(TEAM_WEBPAGE, web.toString());
        }
        IVersionManager vm = (IVersionManager)Container.getComponent(IVersionManager.class);
        copy.setProperty(ROBOCODE_VERSION, vm.getVersion());
        copy.store(os, "Robocode Robot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOrUpdateTeam(File target, URL web, String desc, String author, String members, String teamVersion, String robocodeVersion) throws IOException {
        FileOutputStream os = null;
        try {
            Properties team = TeamItem.loadTeamProps(target);
            if (robocodeVersion != null) {
                team.setProperty(ROBOCODE_VERSION, robocodeVersion);
            }
            if (web != null) {
                team.setProperty(TEAM_WEBPAGE, web.toString());
            }
            if (desc != null) {
                team.setProperty(TEAM_DESCRIPTION, desc);
            }
            if (author != null) {
                team.setProperty(TEAM_AUTHOR_NAME, author);
            }
            if (members != null) {
                team.setProperty(TEAM_MEMBERS, members);
            }
            if (teamVersion != null) {
                team.setProperty(TEAM_VERSION, teamVersion);
            }
            os = new FileOutputStream(target);
            team.store(os, "Robocode robot team");
        }
        catch (Throwable throwable) {
            FileUtil.cleanupStream(os);
            throw throwable;
        }
        FileUtil.cleanupStream((Object)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadTeamProps(File target) {
        Properties team = new Properties();
        if (target.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(target);
                team.load(fis);
            }
            catch (Exception e) {
                try {
                    Logger.logError((Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(fis);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)fis);
            }
            FileUtil.cleanupStream((Object)fis);
        }
        return team;
    }
}

