/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.root.ClassPathRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;

public abstract class ItemHandler {
    public abstract IItem acceptItem(URL var1, IRepositoryRoot var2, Database var3);

    public static IItem registerItems(URL itemURL, IRepositoryRoot root, Database db) {
        List itemHandlerList = Container.getComponents(ItemHandler.class);
        for (ItemHandler handler : itemHandlerList) {
            IItem item = handler.acceptItem(itemURL, root, db);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static String getItemKey(URL itemURL, IRepositoryRoot root) {
        File parentPath;
        assert (itemURL != null);
        assert (root != null);
        if (root instanceof ClassPathRoot && (parentPath = ((ClassPathRoot)root).getParentPath()) != null) {
            return parentPath.toString() + ItemHandler.getItemPart(itemURL);
        }
        String name = itemURL.toString();
        return name.substring(0, name.lastIndexOf(46));
    }

    private static String getItemPart(URL itemURL) {
        String name;
        try {
            name = itemURL.toURI().toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        name = name.replaceAll("\\\\", "/");
        int index = name.lastIndexOf(47);
        if (index > 0) {
            name = name.substring(index);
        }
        if ((index = name.indexOf(46)) > 0) {
            name = name.substring(0, index);
        }
        return name;
    }
}

