/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;

public class PropertiesHandler
extends ItemHandler {
    public IItem acceptItem(URL itemURL, IRepositoryRoot root, Database db) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".properties") && !name.endsWith("robocode.properties")) {
            return this.register(itemURL, root, db);
        }
        return null;
    }

    private IItem register(URL itemURL, IRepositoryRoot root, Database db) {
        String itemKey = PropertiesHandler.getItemKey(itemURL, root);
        RobotItem item = (RobotItem)db.getOldItem(itemKey);
        if (item == null) {
            item = (RobotItem)db.getItem(itemKey);
        }
        if (item == null) {
            item = this.createItem(itemURL, root, db);
        }
        db.putItem(itemKey, item);
        return item;
    }

    protected RobotItem createItem(URL itemURL, IRepositoryRoot root, Database db) {
        RobotItem robotItem = new RobotItem(root);
        robotItem.setPropertiesUrl(itemURL);
        String lang = robotItem.getRobotLanguage();
        if (!lang.equals("java")) {
            String uplang = lang.substring(0, 1).toUpperCase() + lang.substring(1).toLowerCase();
            PropertiesHandler handler = (PropertiesHandler)Container.getComponent(PropertiesHandler.class, (String)(uplang + "PropertiesHandler"));
            return handler.createItem(itemURL, root, db);
        }
        return robotItem;
    }
}

