/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.root.IRepositoryRoot;

public abstract class BaseRoot
implements Serializable,
IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    protected transient Database db;
    protected final File rootPath;
    protected URL rootURL;

    public BaseRoot(Database db, File rootPath) {
        URL url;
        this.db = db;
        this.rootPath = rootPath;
        try {
            url = rootPath.toURI().toURL();
        }
        catch (MalformedURLException e) {
            url = null;
            Logger.logError((Throwable)e);
        }
        this.rootURL = url;
    }

    public URL getRootUrl() {
        try {
            return this.rootPath != null ? this.rootPath.toURI().toURL() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public File getRootPath() {
        return this.rootPath;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public String toString() {
        return this.rootURL != null ? this.rootURL.toString() : null;
    }

    public void extractJar() {
        throw new UnsupportedOperationException();
    }
}

