/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.items.IItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.packager.JarExtractor;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.ui.IWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarRoot
extends BaseRoot
implements IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    private URL jarUrl;
    private String jarNoSeparator;
    private long lastModified;

    public JarRoot(Database db, File rootPath) {
        super(db, rootPath);
        try {
            this.jarNoSeparator = "jar:" + rootPath.toURI().toString();
            this.jarUrl = new URL(this.jarNoSeparator + "!/");
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
    }

    @Override
    public void update(boolean updateInvalid) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        JarRoot.setStatus(windowManager, "Updating .jar: " + this.rootPath.toString());
        long lm = this.rootPath.lastModified();
        if (lm > this.lastModified) {
            this.db.moveOldItems(this);
            this.lastModified = lm;
            ArrayList<IItem> items = new ArrayList<IItem>();
            this.visitItems(items);
            for (IItem item : items) {
                item.update(this.lastModified, updateInvalid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitItems(ArrayList<IItem> items) {
        String root = this.jarNoSeparator;
        InputStream is = null;
        JarInputStream jarIS = null;
        try {
            URLConnection con = URLJarCollector.openConnection((URL)this.rootURL);
            is = con.getInputStream();
            jarIS = new JarInputStream(is);
            this.readJarStream(items, root, jarIS);
        }
        catch (Exception e) {
            try {
                Logger.logError((String)(this.rootURL + " is probably corrupted (" + e.getClass().getName() + " " + e.getMessage() + ")"));
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(jarIS);
                FileUtil.cleanupStream(is);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)jarIS);
            FileUtil.cleanupStream((Object)is);
        }
        FileUtil.cleanupStream((Object)jarIS);
        FileUtil.cleanupStream((Object)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJarStream(ArrayList<IItem> items, String root, JarInputStream jarIS) throws IOException {
        JarEntry entry = jarIS.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName().toLowerCase();
            if (!(entry.isDirectory() || name.contains(".data/") || name.contains(".robotcache/"))) {
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    JarInputStream inner = null;
                    try {
                        inner = new JarInputStream(jarIS);
                        this.readJarStream(items, "jar:jar" + root + "^/" + entry.getName(), inner);
                    }
                    finally {
                        if (inner != null) {
                            inner.closeEntry();
                        }
                    }
                } else {
                    this.createItem(items, new URL(root + "!/"), entry);
                }
            }
            entry = jarIS.getNextJarEntry();
        }
    }

    private void createItem(ArrayList<IItem> items, URL root, JarEntry entry) {
        try {
            String pUrl = root.toString() + entry.getName();
            IItem item = ItemHandler.registerItems(new URL(pUrl), this, this.db);
            if (item != null) {
                if (item instanceof RobotItem) {
                    RobotItem robotItem = (RobotItem)item;
                    robotItem.setClassPathURL(root);
                }
                items.add(item);
            }
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
    }

    @Override
    public void update(IItem item, boolean force) {
        item.update(this.rootPath.lastModified(), force);
    }

    @Override
    public boolean isChanged(IItem item) {
        return this.rootPath.lastModified() > this.lastModified;
    }

    @Override
    public URL getRootUrl() {
        return this.jarUrl;
    }

    @Override
    public boolean isDevel() {
        return false;
    }

    @Override
    public boolean isJar() {
        return true;
    }

    @Override
    public void extractJar() {
        JarExtractor.extractJar(this.rootURL);
    }

    private static void setStatus(IWindowManager windowManager, String message) {
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
    }
}

