/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root.handlers;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Hashtable;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.parsers.ClasspathFileParser;
import net.sf.robocode.repository.root.ClassPathRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathHandler
extends RootHandler {
    @Override
    public void visitDirectory(File dir, boolean isDevel, Hashtable<String, IRepositoryRoot> newroots, Hashtable<String, IRepositoryRoot> roots, Database db, boolean updateInvalid) {
        File classpathFile;
        if (isDevel && (classpathFile = new File(dir, ".classpath")).exists()) {
            ClasspathFileParser classpathParser = new ClasspathFileParser();
            boolean parsed = true;
            try {
                classpathParser.parse(classpathFile.toURL());
            }
            catch (MalformedURLException e) {
                parsed = false;
            }
            if (parsed) {
                String classPath = classpathParser.getClassPath();
                if (classPath != null) {
                    File classPathDir = new File(dir, classPath);
                    this.handleDirectory(classPathDir, dir, newroots, roots, db, updateInvalid);
                }
                for (String sourcePath : classpathParser.getSourcePaths()) {
                    if (sourcePath == null) continue;
                    File sourcePathDir = new File(dir, sourcePath);
                    this.handleDirectory(sourcePathDir, dir, newroots, roots, db, updateInvalid);
                }
                return;
            }
        }
        this.handleDirectory(dir, null, newroots, roots, db, updateInvalid);
    }

    private void handleDirectory(File dir, File parentDir, Hashtable<String, IRepositoryRoot> newroots, Hashtable<String, IRepositoryRoot> roots, Database db, boolean updateInvalid) {
        String key = dir.toURI().toString();
        IRepositoryRoot root = roots.get(key);
        if (root == null) {
            root = new ClassPathRoot(db, dir, parentDir);
        } else {
            roots.remove(key);
        }
        root.update(updateInvalid);
        newroots.put(dir.toURI().toString(), root);
    }
}

