/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root.handlers;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.Database;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.JarRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarHandler
extends RootHandler {
    @Override
    public void visitDirectory(File dir, boolean isDevel, Hashtable<String, IRepositoryRoot> newroots, Hashtable<String, IRepositoryRoot> roots, Database db, boolean updateInvalid) {
        if (!isDevel) {
            File[] jars = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String low = pathname.toString().toLowerCase();
                    return pathname.isFile() && (low.endsWith(".jar") || low.endsWith(".zip"));
                }
            });
            if (jars == null) {
                return;
            }
            for (File jar : jars) {
                String key = jar.toURI().toString();
                IRepositoryRoot root = roots.get(key);
                if (root == null) {
                    root = new JarRoot(db, jar);
                } else {
                    roots.remove(key);
                }
                root.update(updateInvalid);
                newroots.put(key, root);
                try {
                    URLJarCollector.closeJarURLConnection((URL)jar.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    Logger.logError((Throwable)e);
                }
                URLJarCollector.gc();
            }
        }
    }
}

