/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.sound;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import net.sf.robocode.io.Logger;

class SoundCache {
    private final Map<Object, ClipClones> soundTable;
    private final Mixer mixer;

    public SoundCache(Mixer mixer) {
        this.mixer = mixer;
        this.soundTable = new HashMap<Object, ClipClones>();
    }

    public void addSound(Object key, String resourceName, int numClones) {
        if (this.mixer == null || resourceName == null || resourceName.trim().length() == 0) {
            return;
        }
        SoundData data = this.createSoundData(resourceName);
        if (data == null) {
            return;
        }
        try {
            ClipClones clones = new ClipClones(this.mixer, data, numClones);
            this.soundTable.put(key, clones);
        }
        catch (LineUnavailableException e) {
            Logger.logError((String)("The audio mixer " + this.mixer.getMixerInfo().getName() + " does not support the audio format of the sound clip: " + resourceName));
        }
    }

    private SoundData createSoundData(String resourceName) {
        SoundData data;
        URL url = SoundCache.class.getResource(resourceName);
        if (url == null) {
            Logger.logError((String)("Could not load sound because of invalid resource name: " + resourceName));
            return null;
        }
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(url);
            data = new SoundData(ais);
        }
        catch (Exception e) {
            Logger.logError((String)("Error while reading sound from resource: " + resourceName), (Throwable)e);
            data = null;
        }
        return data;
    }

    public Clip getSound(Object key) {
        ClipClones clones = this.soundTable.get(key);
        if (clones == null) {
            return null;
        }
        return clones.next();
    }

    public void removeSound(Object key) {
        ClipClones clones = this.soundTable.get(key);
        if (clones == null) {
            return;
        }
        clones.dispose();
        this.soundTable.remove(key);
    }

    public void clear() {
        for (ClipClones clones : this.soundTable.values()) {
            clones.dispose();
        }
        this.soundTable.clear();
    }

    private static class ClipClones {
        private final Clip[] clips;
        private int idx = 0;

        private ClipClones(Mixer mixer, SoundData soundData, int size) throws LineUnavailableException {
            this.clips = new Clip[size];
            DataLine.Info info = new DataLine.Info(Clip.class, soundData.format);
            if (!AudioSystem.isLineSupported(info)) {
                throw new LineUnavailableException("Required data line is not supported by the audio system");
            }
            for (int i = 0; i < size; ++i) {
                this.clips[i] = (Clip)mixer.getLine(info);
                this.clips[i].open(soundData.format, soundData.byteData, 0, soundData.length);
            }
        }

        private void dispose() {
            for (Clip c : this.clips) {
                c.close();
            }
        }

        private Clip next() {
            Clip c = this.clips[this.idx];
            this.idx = (this.idx + 1) % this.clips.length;
            c.stop();
            c.setFramePosition(0);
            return c;
        }
    }

    private static class SoundData {
        private final AudioFormat format;
        private final int length;
        private final byte[] byteData;

        private SoundData(AudioInputStream ais) throws IOException {
            int bytesRead;
            this.format = ais.getFormat();
            this.length = (int)(ais.getFrameLength() * (long)this.format.getFrameSize());
            this.byteData = new byte[this.length];
            int pos = 0;
            do {
                if ((bytesRead = ais.read(this.byteData, pos, this.length - pos)) <= 0) continue;
                pos += bytesRead;
            } while (bytesRead > 0 && pos < this.length);
            ais.close();
        }
    }
}

