/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.editor.CompilerProperties;
import net.sf.robocode.ui.editor.EditWindow;
import net.sf.robocode.ui.editor.FindReplaceDialog;
import net.sf.robocode.ui.editor.IRobocodeEditor;
import net.sf.robocode.ui.editor.JavaDocument;
import net.sf.robocode.ui.editor.RobocodeCompiler;
import net.sf.robocode.ui.editor.RobocodeCompilerFactory;
import net.sf.robocode.ui.editor.RobocodeEditorMenuBar;
import net.sf.robocode.ui.editor.WindowMenuItem;
import net.sf.robocode.ui.gfx.ImageUtil;

public class RobocodeEditor
extends JFrame
implements Runnable,
IRobocodeEditor {
    private static final int MAX_PACKAGE_NAME_LENGTH = 16;
    private static final int MAX_ROBOT_NAME_LENGTH = 32;
    private JPanel robocodeEditorContentPane;
    private RobocodeEditorMenuBar robocodeEditorMenuBar;
    private JDesktopPane desktopPane;
    public boolean isApplication;
    public final Point origin = new Point();
    public final File robotsDirectory;
    private JToolBar statusBar;
    private JLabel lineLabel;
    private File editorDirectory;
    private final IRepositoryManager repositoryManager;
    private final IWindowManagerExt windowManager;
    private FindReplaceDialog findReplaceDialog;
    private ReplaceAction replaceAction;
    final EventHandler eventHandler = new EventHandler();

    public RobocodeEditor(IRepositoryManager repositoryManager, IWindowManager windowManager) {
        this.windowManager = (IWindowManagerExt)windowManager;
        this.repositoryManager = repositoryManager;
        this.robotsDirectory = FileUtil.getRobotsDir();
        this.initialize();
    }

    public void addPlaceShowFocus(JInternalFrame internalFrame) {
        this.getDesktopPane().add(internalFrame);
        Dimension screenSize = this.getDesktopPane().getSize();
        Dimension size = internalFrame.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        if (this.origin.x + size.width > screenSize.width) {
            this.origin.x = 0;
        }
        if (this.origin.y + size.height > screenSize.height) {
            this.origin.y = 0;
        }
        internalFrame.setLocation(this.origin);
        this.origin.x += 10;
        this.origin.y += 10;
        internalFrame.setVisible(true);
        this.getDesktopPane().moveToFront(internalFrame);
        if (internalFrame instanceof EditWindow) {
            ((EditWindow)internalFrame).getEditorPane().requestFocus();
        } else {
            internalFrame.requestFocus();
        }
    }

    public boolean close() {
        JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        if (frames != null) {
            for (JInternalFrame frame : frames) {
                if (frame == null) continue;
                frame.moveToFront();
                if (!(frame instanceof EditWindow) || ((EditWindow)frame).fileSave(true)) continue;
                return false;
            }
        }
        if (this.isApplication) {
            System.exit(0);
        } else {
            this.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewJavaFile() {
        String packageName = null;
        if (this.getActiveWindow() != null) {
            packageName = this.getActiveWindow().getPackage();
        }
        if (packageName == null) {
            packageName = "mypackage";
        }
        EditWindow editWindow = new EditWindow(this.repositoryManager, this, this.robotsDirectory);
        editWindow.setModified(false);
        String templateName = "templates" + File.separatorChar + "newjavafile.tpt";
        String template = "";
        File f = new File(FileUtil.getCwd(), templateName);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            ((DataInputStream)dis).readFully(buff);
            template = new String(buff);
        }
        catch (IOException e) {
            template = "Unable to read template file: " + FileUtil.getCwd() + File.pathSeparatorChar + templateName;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ignored) {}
            }
        }
        String name = "MyClass";
        int index = template.indexOf("$");
        while (index >= 0) {
            if (template.substring(index, index + 10).equals("$CLASSNAME")) {
                template = template.substring(0, index) + name + template.substring(index + 10);
                index += name.length();
            } else if (template.substring(index, index + 8).equals("$PACKAGE")) {
                template = template.substring(0, index) + packageName + template.substring(index + 8);
                index += packageName.length();
            } else {
                ++index;
            }
            index = template.indexOf("$", index);
        }
        editWindow.getEditorPane().setText(template);
        editWindow.getEditorPane().setCaretPosition(0);
        Document d = editWindow.getEditorPane().getDocument();
        if (d instanceof JavaDocument) {
            ((JavaDocument)d).setEditing(true);
        }
        this.addPlaceShowFocus(editWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewRobot() {
        String message = "Enter the name of your new robot.\nExample: MyFirstRobot";
        String name = "";
        boolean done = false;
        while (!done) {
            if ((name = (String)JOptionPane.showInputDialog(this, message, "New Robot", -1, null, null, name)) == null) {
                return;
            }
            if ((name = name.trim()).length() == 0) {
                return;
            }
            if (name.length() > 32) {
                name = name.substring(0, 32);
                message = "Please choose a shorter name (32 characters or less)";
                continue;
            }
            char firstLetter = name.charAt(0);
            if (!Character.isJavaIdentifierStart(firstLetter) || Character.isLowerCase(firstLetter) || firstLetter == '$') {
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                message = "Please start your robot name with a big letter (A-Z),\nas should the first letter of every word in the name.\nExample: MyFirstRobot";
                continue;
            }
            done = true;
            for (int i = 1; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isJavaIdentifierPart(ch) && ch != '$') continue;
                done = false;
                break;
            }
            if (done) continue;
            message = "Your robot name contains an invalid character.\nPlease use only letters, digits, combination marks and underscores";
        }
        message = "Enter a short package name for your new robot. Your initials will work well here.\nYour robot will be put into this package to avoid name conflict with other robots.\nThe package name is used to identify your robot(s) in the game, especially if you\nwant to let your robot(s) participate in competitions like e.g. RoboRumble@Home.\nHence, you should enter the same package name for all of your robots.";
        String packageName = "";
        done = false;
        while (!done) {
            packageName = (String)JOptionPane.showInputDialog(this, message, "Package name for " + name, -1, null, null, packageName);
            if (packageName == null) {
                return;
            }
            if ((packageName = packageName.trim()).length() == 0) {
                return;
            }
            if (packageName.length() > 16) {
                packageName = packageName.substring(0, 16);
                message = "Please choose a shorter name (16 characters or less)";
                continue;
            }
            char firstLetter = packageName.charAt(0);
            if (!Character.isJavaIdentifierStart(firstLetter) || firstLetter == '$') {
                packageName = packageName.toLowerCase();
                message = "Please start the package name with a small letter (a-z)";
                continue;
            }
            done = true;
            for (int i = 1; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if ((Character.isJavaIdentifierPart(ch) || ch == '.') && ch != '$') continue;
                done = false;
                break;
            }
            if (!done) {
                message = "Your pakage name contains an invalid character.\nPlease use only small letters, digits, combination marks and underscores";
                continue;
            }
            done = false;
            if (packageName.charAt(packageName.length() - 1) == '.') {
                message = "The package name cannot end with a dot";
                continue;
            }
            boolean wrong_dot_combination = false;
            int lastDotIndex = -1;
            for (int i = 0; i < packageName.length(); ++i) {
                if (packageName.charAt(i) != '.') continue;
                if (i - lastDotIndex == 1) {
                    wrong_dot_combination = true;
                }
                lastDotIndex = i;
                break;
            }
            if (wrong_dot_combination) {
                message = "The package name contain two dots next to each other";
                continue;
            }
            if (this.repositoryManager != null) {
                done = this.repositoryManager.verifyRobotName(packageName + "." + name, name);
            }
            if (done) continue;
            message = "This package is reserved. Please select a different package.";
        }
        EditWindow editWindow = new EditWindow(this.repositoryManager, this, this.robotsDirectory);
        editWindow.setRobotName(name);
        editWindow.setModified(false);
        String templateName = "templates" + File.separatorChar + "newrobot.tpt";
        String template = "";
        File f = new File(FileUtil.getCwd(), templateName);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            ((DataInputStream)dis).readFully(buff);
            dis.close();
            template = new String(buff);
        }
        catch (IOException e) {
            template = "Unable to read template file: " + FileUtil.getCwd() + File.pathSeparatorChar + templateName;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ignored) {}
            }
        }
        int index = template.indexOf("$");
        while (index >= 0) {
            if (template.substring(index, index + 10).equals("$CLASSNAME")) {
                template = template.substring(0, index) + name + template.substring(index + 10);
                index += name.length();
            } else if (template.substring(index, index + 8).equals("$PACKAGE")) {
                template = template.substring(0, index) + packageName + template.substring(index + 8);
                index += packageName.length();
            } else {
                ++index;
            }
            index = template.indexOf("$", index);
        }
        editWindow.getEditorPane().setText(template);
        editWindow.getEditorPane().setCaretPosition(0);
        Document d = editWindow.getEditorPane().getDocument();
        if (d instanceof JavaDocument) {
            ((JavaDocument)d).setEditing(true);
        }
        this.addPlaceShowFocus(editWindow);
        if (this.repositoryManager != null) {
            this.repositoryManager.refresh();
        }
    }

    public void findDialog() {
        this.getFindReplaceDialog().showDialog(false);
    }

    public void replaceDialog() {
        this.getFindReplaceDialog().showDialog(true);
    }

    public EditWindow getActiveWindow() {
        JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        EditWindow editWindow = null;
        if (frames != null) {
            for (JInternalFrame frame : frames) {
                if (!frame.isSelected()) continue;
                if (!(frame instanceof EditWindow)) break;
                editWindow = (EditWindow)frame;
                break;
            }
        }
        return editWindow;
    }

    public RobocodeCompiler getCompiler() {
        return ((RobocodeCompilerFactory)Container.getComponent(RobocodeCompilerFactory.class)).createCompiler(this);
    }

    public JDesktopPane getDesktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new JDesktopPane();
            this.desktopPane.setBackground(new Color(128, 128, 128));
            this.desktopPane.setPreferredSize(new Dimension(600, 500));
        }
        return this.desktopPane;
    }

    private JLabel getLineLabel() {
        if (this.lineLabel == null) {
            this.lineLabel = new JLabel();
        }
        return this.lineLabel;
    }

    private JPanel getRobocodeEditorContentPane() {
        if (this.robocodeEditorContentPane == null) {
            this.robocodeEditorContentPane = new JPanel();
            this.robocodeEditorContentPane.setLayout(new BorderLayout());
            this.robocodeEditorContentPane.add((Component)this.getDesktopPane(), "Center");
            this.robocodeEditorContentPane.add((Component)this.getStatusBar(), "South");
        }
        return this.robocodeEditorContentPane;
    }

    private RobocodeEditorMenuBar getRobocodeEditorMenuBar() {
        if (this.robocodeEditorMenuBar == null) {
            this.robocodeEditorMenuBar = new RobocodeEditorMenuBar(this);
        }
        return this.robocodeEditorMenuBar;
    }

    private JToolBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JToolBar();
            this.statusBar.setLayout(new BorderLayout());
            this.statusBar.add((Component)this.getLineLabel(), "West");
        }
        return this.statusBar;
    }

    public FindReplaceDialog getFindReplaceDialog() {
        if (this.findReplaceDialog == null) {
            this.findReplaceDialog = new FindReplaceDialog(this);
        }
        return this.findReplaceDialog;
    }

    public Action getReplaceAction() {
        if (this.replaceAction == null) {
            this.replaceAction = new ReplaceAction();
        }
        return this.replaceAction;
    }

    public void addToWindowMenu(EditWindow window) {
        WindowMenuItem item = new WindowMenuItem(window, this.getRobocodeEditorMenuBar().getWindowMenu());
        this.getRobocodeEditorMenuBar().getMoreWindowsDialog().addWindowItem(item);
    }

    public void removeFromWindowMenu(EditWindow window) {
        for (Component c : this.getRobocodeEditorMenuBar().getWindowMenu().getMenuComponents()) {
            WindowMenuItem item;
            if (!(c instanceof WindowMenuItem) || (item = (WindowMenuItem)c).getEditWindow() != window) continue;
            this.getRobocodeEditorMenuBar().getWindowMenu().remove(item);
            this.getRobocodeEditorMenuBar().getMoreWindowsDialog().removeWindowItem(item);
            break;
        }
    }

    private void initialize() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RobocodeEditor.this.close();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setIconImage(ImageUtil.getImage((String)"/net/sf/robocode/ui/icons/robocode-icon.png"));
        this.setTitle("Robot Editor");
        this.setJMenuBar(this.getRobocodeEditorMenuBar());
        this.setContentPane(this.getRobocodeEditorContentPane());
        this.addComponentListener(this.eventHandler);
    }

    public static void main(String[] args) {
        try {
            IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
            windowManager.setLookAndFeel();
            RobocodeEditor robocodeEditor = (RobocodeEditor)Container.getComponent(RobocodeEditor.class);
            robocodeEditor.isApplication = true;
            robocodeEditor.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension size = robocodeEditor.getSize();
            if (size.height > screenSize.height) {
                size.height = screenSize.height;
            }
            if (size.width > screenSize.width) {
                size.width = screenSize.width;
            }
            robocodeEditor.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
            robocodeEditor.setVisible(true);
            robocodeEditor.setVisible(true);
        }
        catch (Throwable e) {
            Logger.logError((String)"Exception in RoboCodeEditor.main", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRobot() {
        if (this.editorDirectory == null) {
            this.editorDirectory = this.robotsDirectory;
        }
        JFileChooser chooser = new JFileChooser(this.editorDirectory);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isHidden()) {
                    return false;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                String fn = pathname.getName();
                int idx = fn.lastIndexOf(46);
                String extension = "";
                if (idx >= 0) {
                    extension = fn.substring(idx);
                }
                return extension.equalsIgnoreCase(".java");
            }

            public String getDescription() {
                return "Robots";
            }
        };
        chooser.setFileFilter(filter);
        int rv = chooser.showOpenDialog(this);
        if (rv == 0) {
            String robotFilename = chooser.getSelectedFile().getPath();
            this.editorDirectory = chooser.getSelectedFile().getParentFile();
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(robotFilename);
                EditWindow editWindow = new EditWindow(this.repositoryManager, this, this.robotsDirectory);
                editWindow.getEditorPane().read(fileReader, (Object)new File(robotFilename));
                editWindow.getEditorPane().setCaretPosition(0);
                editWindow.setFileName(robotFilename);
                editWindow.setModified(false);
                Document d = editWindow.getEditorPane().getDocument();
                if (d instanceof JavaDocument) {
                    ((JavaDocument)d).setEditing(true);
                }
                this.addPlaceShowFocus(editWindow);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.toString());
                Logger.logError((Throwable)e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    public void extractRobot() {
        this.windowManager.showRobotExtractor((JFrame)this);
    }

    public void run() {
        this.getCompiler();
    }

    public void saveAsRobot() {
        EditWindow editWindow = this.getActiveWindow();
        if (editWindow != null) {
            editWindow.fileSaveAs();
        }
    }

    public void resetCompilerProperties() {
        CompilerProperties props = ((RobocodeCompilerFactory)Container.getComponent(RobocodeCompilerFactory.class)).getCompilerProperties();
        props.resetCompiler();
        RobocodeCompilerFactory cfr_ignored_0 = (RobocodeCompilerFactory)Container.getComponent(RobocodeCompilerFactory.class);
        RobocodeCompilerFactory.saveCompilerProperties();
        this.getCompiler();
    }

    public void saveRobot() {
        EditWindow editWindow = this.getActiveWindow();
        if (editWindow != null) {
            editWindow.fileSave(false);
        }
    }

    public void setLineStatus(int line) {
        if (line >= 0) {
            this.getLineLabel().setText("Line: " + (line + 1));
        } else {
            this.getLineLabel().setText("");
        }
    }

    public void showHelpApi() {
        String helpurl = "file:" + new File(FileUtil.getCwd(), "").getAbsoluteFile() + File.separator + "javadoc" + File.separator + "index.html";
        try {
            BrowserManager.openURL((String)helpurl);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Unable to open browser!", 1);
        }
    }

    public void setSaveFileMenuItemsEnabled(boolean enabled) {
        this.robocodeEditorMenuBar.getFileSaveAsMenuItem().setEnabled(enabled);
        this.robocodeEditorMenuBar.getFileSaveMenuItem().setEnabled(enabled);
    }

    class ReplaceAction
    extends AbstractAction {
        ReplaceAction() {
        }

        public void actionPerformed(ActionEvent e) {
            RobocodeEditor.this.replaceDialog();
        }
    }

    class EventHandler
    implements ComponentListener {
        EventHandler() {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            new Thread(RobocodeEditor.this).start();
        }

        public void componentResized(ComponentEvent e) {
        }
    }
}

