/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;
import net.sf.robocode.ui.editor.JavaDocument;
import net.sf.robocode.ui.editor.Keywords;

public class RobocodeView
extends PlainView {
    public static final Color commentColor = new Color(0, 150, 0);
    public static final Color stringColor = new Color(0, 150, 150);
    public static final Color keywordColor = new Color(0, 0, 150);
    public static final Color textColor = Color.black;
    public static final int TEXT = 0;
    public static final int KEYWORD = 1;
    public static final int COMMENT = 2;
    public static final int STRING = 3;
    public static final int MULTILINECOMMENT = 4;

    public RobocodeView(Element elem) {
        super(elem);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        JavaDocument d = (JavaDocument)e.getDocument();
        if (d.isNeedsRedraw()) {
            this.getContainer().repaint();
            d.setNeedsRedraw(false);
        }
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        Segment segment = new Segment();
        Segment token = this.getLineBuffer();
        doc.getText(p0, p1 - p0, segment);
        int count = p1 - p0;
        int left = 0;
        int state = 0;
        int elementIndex = doc.getDefaultRootElement().getElementIndex(p0);
        AttributeSet lineAttributes = doc.getDefaultRootElement().getElement(elementIndex).getAttributes();
        if (lineAttributes.isDefined("inComment")) {
            state = 4;
        }
        for (int i = 0; i < count; ++i) {
            if (state == 0) {
                if (Character.isLetter(segment.array[i + segment.offset]) && Character.isLowerCase(segment.array[i + segment.offset])) {
                    g.setColor(textColor);
                    doc.getText(p0 + left, i - left, token);
                    x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
                    left = i;
                    state = 1;
                    continue;
                }
                if (segment.array[i + segment.offset] == '/') {
                    g.setColor(textColor);
                    doc.getText(p0 + left, i - left, token);
                    x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
                    left = i;
                    state = 2;
                    continue;
                }
                if (segment.array[i + segment.offset] != '\"') continue;
                g.setColor(textColor);
                doc.getText(p0 + left, i - left, token);
                x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
                left = i;
                state = 3;
                continue;
            }
            if (state == 1) {
                if (Character.isLetter(segment.array[i + segment.offset])) continue;
                doc.getText(p0 + left, i - left, token);
                if (Keywords.isKeyword(token)) {
                    g.setColor(keywordColor);
                } else {
                    g.setColor(textColor);
                }
                x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
                left = i;
                state = 0;
                if (segment.array[i + segment.offset] == '/') {
                    state = 2;
                    continue;
                }
                if (segment.array[i + segment.offset] != '\"') continue;
                state = 3;
                continue;
            }
            if (state == 2) {
                if (segment.array[i + segment.offset] == '/') break;
                if (segment.array[i + segment.offset] == '*') {
                    state = 4;
                    continue;
                }
                state = 0;
                continue;
            }
            if (state == 4) {
                if (i <= 0 || segment.array[i + segment.offset] != '/' || segment.array[i + segment.offset - 1] != '*') continue;
                doc.getText(p0 + left, i + 1 - left, token);
                g.setColor(commentColor);
                x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
                left = i + 1;
                state = 0;
                continue;
            }
            if (state != 3 || segment.array[i + segment.offset] != '\"') continue;
            doc.getText(p0 + left, i + 1 - left, token);
            g.setColor(stringColor);
            x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
            left = i + 1;
            state = 0;
        }
        doc.getText(p0 + left, p1 - p0 - left, token);
        if (state == 1) {
            if (Keywords.isKeyword(token)) {
                g.setColor(keywordColor);
            } else {
                g.setColor(textColor);
            }
        } else if (state == 3) {
            g.setColor(stringColor);
        } else if (state == 2 && p1 - p0 - left > 1) {
            g.setColor(commentColor);
        } else if (state == 4) {
            g.setColor(commentColor);
        } else {
            g.setColor(textColor);
        }
        x = Utilities.drawTabbedText(token, x, y, g, (TabExpander)this, p0 + left);
        return x;
    }

    protected int getTabSize() {
        return 4;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
        JavaDocument d = (JavaDocument)e.getDocument();
        if (d.isNeedsRedraw()) {
            this.getContainer().repaint();
            d.setNeedsRedraw(false);
        }
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
        JavaDocument d = (JavaDocument)e.getDocument();
        if (d.isNeedsRedraw()) {
            this.getContainer().repaint();
            d.setNeedsRedraw(false);
        }
    }
}

