/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.robocode.io.FileUtil;

public class BrowserManager {
    public static void openURL(String url) throws IOException {
        if (System.getProperty("java.version").charAt(2) >= '6') {
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                Object desktop = desktopClass.getDeclaredMethod("getDesktop", null).invoke((Object)null, (Object[])null);
                desktopClass.getDeclaredMethod("browse", URI.class).invoke(desktop, new URI(url));
                return;
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        url = FileUtil.quoteFileName((String)url);
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            rt.exec("rundll32 url.dll, FileProtocolHandler " + url);
        } else if (os.startsWith("mac")) {
            rt.exec("open " + url);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "galeon", "netscape", "opera", "links", "lynx"};
            StringBuffer cmd = new StringBuffer();
            for (int i = 0; i < browsers.length; ++i) {
                cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
            }
            rt.exec(new String[]{"sh", "-c", cmd.toString()});
        }
    }
}

