/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.BattleResultsTableModel;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.IImageManager;
import net.sf.robocode.ui.IRobotDialogManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.RobotDialogManager;
import net.sf.robocode.ui.battle.AwtBattleAdaptor;
import net.sf.robocode.ui.dialog.AboutBox;
import net.sf.robocode.ui.dialog.NewBattleDialog;
import net.sf.robocode.ui.dialog.PreferencesDialog;
import net.sf.robocode.ui.dialog.RankingDialog;
import net.sf.robocode.ui.dialog.RcSplashScreen;
import net.sf.robocode.ui.dialog.ResultsDialog;
import net.sf.robocode.ui.dialog.RobocodeFrame;
import net.sf.robocode.ui.dialog.RobotExtractor;
import net.sf.robocode.ui.dialog.TeamCreator;
import net.sf.robocode.ui.dialog.WindowUtil;
import net.sf.robocode.ui.editor.IRobocodeEditor;
import net.sf.robocode.ui.packager.RobotPackager;
import net.sf.robocode.version.IVersionManager;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.snapshot.ITurnSnapshot;

public class WindowManager
implements IWindowManagerExt {
    private static final int TIMER_TICKS_PER_SECOND = 50;
    private final AwtBattleAdaptor awtAdaptor;
    private RobotPackager robotPackager;
    private RobotExtractor robotExtractor;
    private final ISettingsManager properties;
    private final IBattleManager battleManager;
    private final ICpuManager cpuManager;
    private final IRepositoryManager repositoryManager;
    private final IVersionManager versionManager;
    private IRobotDialogManager robotDialogManager;
    private RobocodeFrame robocodeFrame;
    private boolean isGUIEnabled = true;
    private boolean isSlave;
    private boolean centerRankings = true;
    private boolean oldRankingHideState = true;
    private boolean showResults = true;

    public WindowManager(ISettingsManager properties, IBattleManager battleManager, ICpuManager cpuManager, IRepositoryManager repositoryManager, IImageManager imageManager, IVersionManager versionManager) {
        this.properties = properties;
        this.battleManager = battleManager;
        this.repositoryManager = repositoryManager;
        this.cpuManager = cpuManager;
        this.versionManager = versionManager;
        this.awtAdaptor = new AwtBattleAdaptor(battleManager, 50, true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.currentThread().setPriority(7);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        });
        imageManager.initialize();
    }

    public void setBusyPointer(boolean enabled) {
        this.robocodeFrame.setBusyPointer(enabled);
    }

    public synchronized void addBattleListener(IBattleListener listener) {
        this.awtAdaptor.addListener(listener);
    }

    public synchronized void removeBattleListener(IBattleListener listener) {
        this.awtAdaptor.removeListener(listener);
    }

    public boolean isGUIEnabled() {
        return this.isGUIEnabled;
    }

    public void setEnableGUI(boolean enable) {
        this.isGUIEnabled = enable;
        System.setProperty("java.awt.headless", "" + !enable);
    }

    public void setSlave(boolean value) {
        this.isSlave = value;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public boolean isShowResultsEnabled() {
        return this.properties.getOptionsCommonShowResults() && this.showResults;
    }

    public void setEnableShowResults(boolean enable) {
        this.showResults = enable;
    }

    public ITurnSnapshot getLastSnapshot() {
        return this.awtAdaptor.getLastSnapshot();
    }

    public int getFPS() {
        return this.awtAdaptor.getFPS();
    }

    public RobocodeFrame getRobocodeFrame() {
        if (this.robocodeFrame == null) {
            this.robocodeFrame = (RobocodeFrame)Container.getComponent(RobocodeFrame.class);
        }
        return this.robocodeFrame;
    }

    public void showRobocodeFrame(boolean visible, boolean iconified) {
        RobocodeFrame frame = this.getRobocodeFrame();
        if (iconified) {
            frame.setState(1);
        }
        if (visible) {
            WindowUtil.packCenterShow(frame);
            WindowUtil.setStatusLabel(frame.getStatusLabel());
            frame.checkUpdateOnStart();
        } else {
            frame.setVisible(false);
        }
    }

    public void showAboutBox() {
        this.packCenterShow((Window)Container.getComponent(AboutBox.class), true);
    }

    public String showBattleOpenDialog(final String defExt, final String name) {
        JFileChooser chooser = new JFileChooser(this.battleManager.getBattlePath());
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().lastIndexOf(defExt.toLowerCase()) == pathname.getName().length() - defExt.length();
            }

            public String getDescription() {
                return name;
            }
        });
        if (chooser.showOpenDialog(this.getRobocodeFrame()) == 0) {
            return chooser.getSelectedFile().getPath();
        }
        return null;
    }

    public String saveBattleDialog(String path, final String defExt, final String name) {
        File f = new File(path);
        JFileChooser chooser = new JFileChooser(f);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().lastIndexOf(defExt.toLowerCase()) == pathname.getName().length() - defExt.length();
            }

            public String getDescription() {
                return name;
            }
        };
        chooser.setFileFilter(filter);
        int rv = chooser.showSaveDialog(this.getRobocodeFrame());
        String result = null;
        if (rv == 0) {
            result = chooser.getSelectedFile().getPath();
            int idx = result.lastIndexOf(46);
            String extension = "";
            if (idx > 0) {
                extension = result.substring(idx);
            }
            if (!extension.equalsIgnoreCase(defExt)) {
                result = result + defExt;
            }
        }
        return result;
    }

    public void showVersionsTxt() {
        this.showInBrowser("file://" + new File(FileUtil.getCwd(), "").getAbsoluteFile() + File.separator + "versions.txt");
    }

    public void showHelpApi() {
        this.showInBrowser("file://" + new File(FileUtil.getCwd(), "").getAbsoluteFile() + File.separator + "javadoc" + File.separator + "index.html");
    }

    public void showFaq() {
        this.showInBrowser("http://robowiki.net/w/index.php?title=Robocode/FAQ");
    }

    public void showOnlineHelp() {
        this.showInBrowser("http://robowiki.net/w/index.php?title=Robocode/Getting_Started");
    }

    public void showJavaDocumentation() {
        this.showInBrowser("http://java.sun.com/j2se/1.5.0/docs");
    }

    public void showRobocodeHome() {
        this.showInBrowser("http://robocode.sourceforge.net");
    }

    public void showRoboWiki() {
        this.showInBrowser("http://robowiki.net");
    }

    public void showYahooGroupRobocode() {
        this.showInBrowser("http://groups.yahoo.com/group/robocode");
    }

    public void showRobocodeRepository() {
        this.showInBrowser("http://robocoderepository.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOptionsPreferences() {
        try {
            this.battleManager.pauseBattle();
            WindowUtil.packCenterShow(this.getRobocodeFrame(), (Window)Container.getComponent(PreferencesDialog.class));
        }
        finally {
            this.battleManager.resumeIfPausedBattle();
        }
    }

    public void showResultsDialog(BattleCompletedEvent event) {
        ResultsDialog dialog = (ResultsDialog)Container.getComponent(ResultsDialog.class);
        dialog.setup(event.getSortedResults(), event.getBattleRules().getNumRounds());
        this.packCenterShow(dialog, true);
    }

    public void showRankingDialog(boolean visible) {
        boolean currentRankingHideState = this.properties.getOptionsCommonDontHideRankings();
        if (currentRankingHideState != this.oldRankingHideState) {
            ((RankingDialog)Container.getComponent(RankingDialog.class)).dispose();
            Container.cache.removeComponent(RankingDialog.class);
            Container.cache.addComponent(RankingDialog.class);
            this.centerRankings = true;
        }
        RankingDialog rankingDialog = (RankingDialog)Container.getComponent(RankingDialog.class);
        if (visible) {
            this.packCenterShow(rankingDialog, this.centerRankings);
            this.centerRankings = false;
        } else {
            rankingDialog.dispose();
        }
        this.oldRankingHideState = currentRankingHideState;
    }

    public void showRobocodeEditor() {
        JFrame editor = (JFrame)Container.getComponent(IRobocodeEditor.class);
        if (!editor.isVisible()) {
            WindowUtil.packCenterShow(editor);
        } else {
            editor.setVisible(true);
        }
    }

    public void showRobotPackager() {
        if (this.robotPackager != null) {
            this.robotPackager.dispose();
            this.robotPackager = null;
        }
        this.robotPackager = (RobotPackager)Container.factory.getComponent(RobotPackager.class);
        WindowUtil.packCenterShow(this.robotPackager);
    }

    public void showRobotExtractor(JFrame owner) {
        if (this.robotExtractor != null) {
            this.robotExtractor.dispose();
            this.robotExtractor = null;
        }
        this.robotExtractor = new RobotExtractor(owner, this, this.repositoryManager);
        WindowUtil.packCenterShow(this.robotExtractor);
    }

    public void showSplashScreen() {
        RcSplashScreen splashScreen = (RcSplashScreen)Container.getComponent(RcSplashScreen.class);
        this.packCenterShow(splashScreen, true);
        WindowUtil.setStatusLabel(splashScreen.getSplashLabel());
        this.repositoryManager.reload(this.versionManager.isLastRunVersionChanged());
        WindowUtil.setStatusLabel(splashScreen.getSplashLabel());
        this.cpuManager.getCpuConstant();
        WindowUtil.setStatus("");
        WindowUtil.setStatusLabel(null);
        splashScreen.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNewBattleDialog(BattleProperties battleProperties, boolean openBattle) {
        try {
            this.battleManager.pauseBattle();
            NewBattleDialog battleDialog = (NewBattleDialog)Container.createComponent(NewBattleDialog.class);
            battleDialog.setup(battleProperties, openBattle);
            WindowUtil.packCenterShow(this.getRobocodeFrame(), battleDialog);
        }
        finally {
            this.battleManager.resumeBattle();
        }
    }

    public boolean closeRobocodeEditor() {
        IRobocodeEditor editor = (IRobocodeEditor)Container.getComponent(IRobocodeEditor.class);
        return editor == null || !((JFrame)((Object)editor)).isVisible() || editor.close();
    }

    public void showCreateTeamDialog() {
        TeamCreator teamCreator = (TeamCreator)Container.getComponent(TeamCreator.class);
        WindowUtil.packCenterShow(teamCreator);
    }

    public void showImportRobotDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isHidden()) {
                    return false;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                String filename = pathname.getName();
                if (filename.equals("robocode.jar")) {
                    return false;
                }
                int idx = filename.lastIndexOf(46);
                String extension = "";
                if (idx >= 0) {
                    extension = filename.substring(idx);
                }
                return extension.equalsIgnoreCase(".jar") || extension.equalsIgnoreCase(".zip");
            }

            public String getDescription() {
                return "Jar Files";
            }
        });
        chooser.setDialogTitle("Select the robot .jar file to copy to " + this.repositoryManager.getRobotsDirectory());
        if (chooser.showDialog(this.getRobocodeFrame(), "Import") == 0) {
            File outputFile;
            File inputFile = chooser.getSelectedFile();
            String fileName = inputFile.getName();
            String extension = "";
            int idx = fileName.lastIndexOf(46);
            if (idx >= 0) {
                extension = fileName.substring(idx);
            }
            if (!extension.equalsIgnoreCase(".jar")) {
                fileName = fileName + ".jar";
            }
            if (inputFile.equals(outputFile = new File(this.repositoryManager.getRobotsDirectory(), fileName))) {
                JOptionPane.showMessageDialog(this.getRobocodeFrame(), outputFile.getName() + " is already in the robots directory!");
                return;
            }
            if (outputFile.exists() && JOptionPane.showConfirmDialog(this.getRobocodeFrame(), outputFile + " already exists.  Overwrite?", "Warning", 0) == 1) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this.getRobocodeFrame(), "Robocode will now copy " + inputFile.getName() + " to " + outputFile.getParent(), "Import robot", 2) == 0) {
                try {
                    FileUtil.copy((File)inputFile, (File)outputFile);
                    this.repositoryManager.refresh();
                    JOptionPane.showMessageDialog(this.getRobocodeFrame(), "Robot imported successfully.");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.getRobocodeFrame(), "Import failed: " + e);
                }
            }
        }
    }

    private void showInBrowser(String url) {
        try {
            BrowserManager.openURL(url);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getRobocodeFrame(), e.getMessage(), "Unable to open browser!", 0);
        }
    }

    public void showSaveResultsDialog(BattleResultsTableModel tableModel) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isHidden()) {
                    return false;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                String filename = pathname.getName();
                int idx = filename.lastIndexOf(46);
                String extension = "";
                if (idx >= 0) {
                    extension = filename.substring(idx);
                }
                return extension.equalsIgnoreCase(".csv");
            }

            public String getDescription() {
                return "Comma Separated Value (CSV) File Format";
            }
        });
        chooser.setDialogTitle("Save battle results");
        if (chooser.showSaveDialog(this.getRobocodeFrame()) == 0) {
            String filename = chooser.getSelectedFile().getPath();
            if (!filename.endsWith(".csv")) {
                filename = filename + ".csv";
            }
            boolean append = this.properties.getOptionsCommonAppendWhenSavingResults();
            tableModel.saveToFile(filename, append);
        }
    }

    private void packCenterShow(Window window, boolean center) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        window.pack();
        if (center) {
            window.setLocation((screenSize.width - window.getWidth()) / 2, (screenSize.height - window.getHeight()) / 2);
        }
        window.setVisible(true);
    }

    public void cleanup() {
        if (this.isGUIEnabled()) {
            this.getRobocodeFrame().dispose();
        }
    }

    public void setStatus(String s) {
        WindowUtil.setStatus(s);
    }

    public void messageWarning(String s) {
        WindowUtil.messageWarning(s);
    }

    public IRobotDialogManager getRobotDialogManager() {
        if (this.robotDialogManager == null) {
            this.robotDialogManager = new RobotDialogManager();
        }
        return this.robotDialogManager;
    }

    public void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            Locale.setDefault(Locale.US);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable t2) {
                System.err.println("Could not set the Look and Feel (LAF).  The default LAF is used instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIntroBattle() {
        File intro = new File(FileUtil.getCwd(), "battles/intro.battle");
        if (intro.exists()) {
            this.battleManager.setBattleFilename(intro.getPath());
            this.battleManager.loadBattleProperties();
            boolean origShowResults = this.showResults;
            this.showResults = false;
            try {
                this.battleManager.startNewBattle(this.battleManager.loadBattleProperties(), true, false);
                this.battleManager.setDefaultBattleProperties();
                this.robocodeFrame.afterIntroBattle();
            }
            finally {
                this.showResults = origShowResults;
            }
        }
    }

    public void setVisibleForRobotEngine(boolean visible) {
        if (visible && !this.isGUIEnabled()) {
            this.setEnableGUI(true);
            this.setLookAndFeel();
        }
        if (this.isGUIEnabled()) {
            this.showRobocodeFrame(visible, false);
            this.showResults = visible;
        }
    }
}

