/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.battleview;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.sf.robocode.battle.snapshot.RobotSnapshot;
import net.sf.robocode.robotpaint.Graphics2DSerialized;
import net.sf.robocode.robotpaint.IGraphicsProxy;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IImageManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.battleview.BattleField;
import net.sf.robocode.ui.battleview.MirroredGraphics;
import net.sf.robocode.ui.gfx.GraphicsState;
import net.sf.robocode.ui.gfx.RenderImage;
import net.sf.robocode.ui.gfx.RobocodeLogo;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.BulletState;
import robocode.control.snapshot.IBulletSnapshot;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public class BattleView
extends Canvas {
    private static final String ROBOCODE_SLOGAN = "Build the best, destroy the rest";
    private static final Color CANVAS_BG_COLOR = SystemColor.controlDkShadow;
    private static final Area BULLET_AREA = new Area(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0));
    private static final int ROBOT_TEXT_Y_OFFSET = 24;
    private BattleField battleField;
    private boolean initialized;
    private double scale = 1.0;
    private int[][] groundTiles;
    private final int groundTileWidth = 64;
    private final int groundTileHeight = 64;
    private Image groundImage;
    private boolean drawRobotName;
    private boolean drawRobotEnergy;
    private boolean drawScanArcs;
    private boolean drawExplosions;
    private boolean drawGround;
    private boolean drawExplosionDebris;
    private int numBuffers = 2;
    private RenderingHints renderingHints;
    private Font smallFont;
    private FontMetrics smallFontMetrics;
    private final IImageManager imageManager;
    private final ISettingsManager properties;
    private final IWindowManagerExt windowManager;
    private BufferStrategy bufferStrategy;
    private Image offscreenImage;
    private Graphics2D offscreenGfx;
    private final GeneralPath robocodeTextPath = new RobocodeLogo().getRobocodeText();
    private static final MirroredGraphics mirroredGraphics = new MirroredGraphics();
    private final GraphicsState graphicsState = new GraphicsState();
    private IGraphicsProxy[] robotGraphics;

    public BattleView(ISettingsManager properties, IWindowManager windowManager, IImageManager imageManager) {
        this.properties = properties;
        this.windowManager = (IWindowManagerExt)windowManager;
        this.imageManager = imageManager;
        this.battleField = new BattleField(800, 600);
        new BattleObserver(windowManager);
        properties.addPropertyListener(new ISettingsListener(){

            public void settingChanged(String property) {
                BattleView.this.loadDisplayOptions();
                if (property.startsWith("robocode.options.rendering")) {
                    BattleView.this.initialized = false;
                    BattleView.this.validate();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BattleView.this.initialized = false;
                BattleView.this.validate();
            }
        });
    }

    public void paint(Graphics g) {
        ITurnSnapshot lastSnapshot = this.windowManager.getLastSnapshot();
        if (lastSnapshot != null) {
            this.update(lastSnapshot);
        } else {
            this.paintRobocodeLogo((Graphics2D)g);
        }
    }

    public BufferedImage getScreenshot() {
        BufferedImage screenshot = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
        if (this.windowManager.getLastSnapshot() == null) {
            this.paintRobocodeLogo((Graphics2D)screenshot.getGraphics());
        } else {
            screenshot.getGraphics().drawImage(this.offscreenImage, 0, 0, null);
        }
        return screenshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ITurnSnapshot snapshot) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.offscreenImage == null || !this.isDisplayable() || this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        this.offscreenGfx = (Graphics2D)this.offscreenImage.getGraphics();
        if (this.offscreenGfx != null) {
            this.offscreenGfx.setRenderingHints(this.renderingHints);
            this.drawBattle(this.offscreenGfx, snapshot);
            if (this.bufferStrategy != null) {
                Graphics2D g = null;
                try {
                    g = (Graphics2D)this.bufferStrategy.getDrawGraphics();
                    g.drawImage(this.offscreenImage, 0, 0, null);
                    this.bufferStrategy.show();
                }
                catch (NullPointerException nullPointerException) {
                }
                finally {
                    if (g != null) {
                        g.dispose();
                    }
                }
            }
        }
    }

    private void loadDisplayOptions() {
        ISettingsManager props = this.properties;
        this.drawRobotName = props.getOptionsViewRobotNames();
        this.drawRobotEnergy = props.getOptionsViewRobotEnergy();
        this.drawScanArcs = props.getOptionsViewScanArcs();
        this.drawGround = props.getOptionsViewGround();
        this.drawExplosions = props.getOptionsViewExplosions();
        this.drawExplosionDebris = props.getOptionsViewExplosionDebris();
        this.renderingHints = props.getRenderingHints();
        this.numBuffers = props.getOptionsRenderingNoBuffers();
    }

    private void initialize() {
        this.loadDisplayOptions();
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        this.offscreenImage = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
        this.offscreenGfx = (Graphics2D)this.offscreenImage.getGraphics();
        if (this.bufferStrategy == null) {
            this.createBufferStrategy(this.numBuffers);
            this.bufferStrategy = this.getBufferStrategy();
        }
        if (this.getWidth() < this.battleField.getWidth() || this.getHeight() < this.battleField.getHeight()) {
            this.scale = Math.min((double)this.getWidth() / (double)this.battleField.getWidth(), (double)this.getHeight() / (double)this.battleField.getHeight());
            this.offscreenGfx.scale(this.scale, this.scale);
        } else {
            this.scale = 1.0;
        }
        this.smallFont = new Font("Dialog", 0, (int)(10.0 / this.scale));
        this.smallFontMetrics = this.offscreenGfx.getFontMetrics(this.smallFont);
        if (this.drawGround) {
            this.createGroundImage();
        } else {
            this.groundImage = null;
        }
        this.initialized = true;
    }

    private void createGroundImage() {
        Random r = new Random();
        int NUM_HORZ_TILES = this.battleField.getWidth() / 64 + 1;
        int NUM_VERT_TILES = this.battleField.getHeight() / 64 + 1;
        if (this.groundTiles == null || this.groundTiles.length != NUM_VERT_TILES || this.groundTiles[0].length != NUM_HORZ_TILES) {
            this.groundTiles = new int[NUM_VERT_TILES][NUM_HORZ_TILES];
            for (int y = NUM_VERT_TILES - 1; y >= 0; --y) {
                for (int x = NUM_HORZ_TILES - 1; x >= 0; --x) {
                    this.groundTiles[y][x] = (int)Math.round(r.nextDouble() * 4.0);
                }
            }
        }
        int groundWidth = (int)((double)this.battleField.getWidth() * this.scale);
        int groundHeight = (int)((double)this.battleField.getHeight() * this.scale);
        this.groundImage = new BufferedImage(groundWidth, groundHeight, 1);
        Graphics2D groundGfx = (Graphics2D)this.groundImage.getGraphics();
        groundGfx.setRenderingHints(this.renderingHints);
        groundGfx.setTransform(AffineTransform.getScaleInstance(this.scale, this.scale));
        for (int y = NUM_VERT_TILES - 1; y >= 0; --y) {
            for (int x = NUM_HORZ_TILES - 1; x >= 0; --x) {
                Image img = this.imageManager.getGroundTileImage(this.groundTiles[y][x]);
                if (img == null) continue;
                groundGfx.drawImage(img, x * 64, y * 64, null);
            }
        }
    }

    private void drawBattle(Graphics2D g, ITurnSnapshot snapShot) {
        this.graphicsState.save(g);
        g.setTransform(new AffineTransform());
        g.setClip(null);
        g.setColor(CANVAS_BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double dx = ((double)this.getWidth() - this.scale * (double)this.battleField.getWidth()) / 2.0;
        double dy = ((double)this.getHeight() - this.scale * (double)this.battleField.getHeight()) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
        at.concatenate(AffineTransform.getScaleInstance(this.scale, this.scale));
        g.setTransform(at);
        g.setClip(0, 0, this.battleField.getWidth(), this.battleField.getHeight());
        this.drawGround(g);
        if (snapShot != null) {
            this.drawScanArcs(g, snapShot);
            this.drawRobots(g, snapShot);
            this.drawRobotPaint(g, snapShot);
        }
        this.drawBorder(g);
        if (snapShot != null) {
            this.drawBullets(g, snapShot);
            this.drawText(g, snapShot);
        }
        this.graphicsState.restore(g);
    }

    private void drawGround(Graphics2D g) {
        if (!this.drawGround) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.battleField.getWidth(), this.battleField.getHeight());
        } else {
            if (this.groundImage == null) {
                this.createGroundImage();
            }
            if (this.groundImage != null) {
                int groundWidth = (int)((double)this.battleField.getWidth() * this.scale) + 1;
                int groundHeight = (int)((double)this.battleField.getHeight() * this.scale) + 1;
                int dx = (this.getWidth() - groundWidth) / 2;
                int dy = (this.getHeight() - groundHeight) / 2;
                AffineTransform savedTx = g.getTransform();
                g.setTransform(new AffineTransform());
                g.drawImage(this.groundImage, dx, dy, groundWidth, groundHeight, null);
                g.setTransform(savedTx);
            }
        }
    }

    private void drawBorder(Graphics2D g) {
        Shape savedClip = g.getClip();
        g.setClip(null);
        g.setColor(Color.RED);
        g.drawRect(-1, -1, this.battleField.getWidth() + 2, this.battleField.getHeight() + 2);
        g.setClip(savedClip);
    }

    private void drawScanArcs(Graphics2D g, ITurnSnapshot snapShot) {
        if (this.drawScanArcs) {
            for (IRobotSnapshot robotSnapshot : snapShot.getRobots()) {
                if (!robotSnapshot.getState().isAlive()) continue;
                this.drawScanArc(g, robotSnapshot);
            }
        }
    }

    private void drawRobots(Graphics2D g, ITurnSnapshot snapShot) {
        AffineTransform at;
        double y;
        double x;
        int battleFieldHeight = this.battleField.getHeight();
        if (this.drawGround && this.drawExplosionDebris) {
            RenderImage explodeDebrise = this.imageManager.getExplosionDebriseRenderImage();
            for (IRobotSnapshot robotSnapshot : snapShot.getRobots()) {
                if (!robotSnapshot.getState().isDead()) continue;
                x = robotSnapshot.getX();
                y = (double)battleFieldHeight - robotSnapshot.getY();
                at = AffineTransform.getTranslateInstance(x, y);
                explodeDebrise.setTransform(at);
                explodeDebrise.paint(g);
            }
        }
        for (IRobotSnapshot robotSnapshot : snapShot.getRobots()) {
            if (!robotSnapshot.getState().isAlive()) continue;
            x = robotSnapshot.getX();
            y = (double)battleFieldHeight - robotSnapshot.getY();
            at = AffineTransform.getTranslateInstance(x, y);
            at.rotate(robotSnapshot.getBodyHeading());
            RenderImage robotRenderImage = this.imageManager.getColoredBodyRenderImage(robotSnapshot.getBodyColor());
            robotRenderImage.setTransform(at);
            robotRenderImage.paint(g);
            at = AffineTransform.getTranslateInstance(x, y);
            at.rotate(robotSnapshot.getGunHeading());
            RenderImage gunRenderImage = this.imageManager.getColoredGunRenderImage(robotSnapshot.getGunColor());
            gunRenderImage.setTransform(at);
            gunRenderImage.paint(g);
            if (robotSnapshot.isDroid()) continue;
            at = AffineTransform.getTranslateInstance(x, y);
            at.rotate(robotSnapshot.getRadarHeading());
            RenderImage radarRenderImage = this.imageManager.getColoredRadarRenderImage(robotSnapshot.getRadarColor());
            radarRenderImage.setTransform(at);
            radarRenderImage.paint(g);
        }
    }

    private void drawText(Graphics2D g, ITurnSnapshot snapShot) {
        Shape savedClip = g.getClip();
        g.setClip(null);
        for (IRobotSnapshot robotSnapshot : snapShot.getRobots()) {
            if (robotSnapshot.getState().isDead()) continue;
            int x = (int)robotSnapshot.getX();
            int y = this.battleField.getHeight() - (int)robotSnapshot.getY();
            if (this.drawRobotEnergy) {
                g.setColor(Color.white);
                int ll = (int)robotSnapshot.getEnergy();
                int rl = (int)((robotSnapshot.getEnergy() - (double)ll + 0.001) * 10.0);
                if (rl == 10) {
                    rl = 9;
                }
                String energyString = ll + "." + rl;
                if (robotSnapshot.getEnergy() == 0.0 && robotSnapshot.getState().isAlive()) {
                    energyString = "Disabled";
                }
                this.centerString(g, energyString, x, y - 24 - this.smallFontMetrics.getHeight() / 2, this.smallFont, this.smallFontMetrics);
            }
            if (!this.drawRobotName) continue;
            g.setColor(Color.white);
            this.centerString(g, robotSnapshot.getVeryShortName(), x, y + 24 + this.smallFontMetrics.getHeight() / 2, this.smallFont, this.smallFontMetrics);
        }
        g.setClip(savedClip);
    }

    private void drawRobotPaint(Graphics2D g, ITurnSnapshot turnSnapshot) {
        int robotIndex = 0;
        for (IRobotSnapshot robotSnapshot : turnSnapshot.getRobots()) {
            Object graphicsCalls = ((RobotSnapshot)robotSnapshot).getGraphicsCalls();
            if (graphicsCalls == null || !robotSnapshot.isPaintEnabled()) continue;
            GraphicsState gfxState = new GraphicsState();
            gfxState.save(g);
            g.setClip(null);
            g.setComposite(AlphaComposite.SrcAtop);
            IGraphicsProxy gfxProxy = this.getRobotGraphics(robotIndex);
            if (robotSnapshot.isSGPaintEnabled()) {
                gfxProxy.processTo(g, graphicsCalls);
            } else {
                mirroredGraphics.bind(g, this.battleField.getHeight());
                gfxProxy.processTo((Graphics2D)mirroredGraphics, graphicsCalls);
                mirroredGraphics.release();
            }
            gfxState.restore(g);
            ++robotIndex;
        }
    }

    private IGraphicsProxy getRobotGraphics(int robotIndex) {
        if (this.robotGraphics[robotIndex] == null) {
            this.robotGraphics[robotIndex] = new Graphics2DSerialized();
            this.robotGraphics[robotIndex].setPaintingEnabled(true);
        }
        return this.robotGraphics[robotIndex];
    }

    private void drawBullets(Graphics2D g, ITurnSnapshot snapShot) {
        Shape savedClip = g.getClip();
        g.setClip(null);
        for (IBulletSnapshot IBulletSnapshot2 : snapShot.getBullets()) {
            double scale;
            double x = IBulletSnapshot2.getPaintX();
            double y = (double)this.battleField.getHeight() - IBulletSnapshot2.getPaintY();
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            if (IBulletSnapshot2.getState().getValue() <= BulletState.MOVING.getValue()) {
                scale = Math.max(2.0 * Math.sqrt(2.5 * IBulletSnapshot2.getPower()), 2.0 / this.scale);
                at.scale(scale, scale);
                Area bulletArea = BULLET_AREA.createTransformedArea(at);
                Color bulletColor = this.properties.getOptionsRenderingForceBulletColor() ? Color.WHITE : new Color(IBulletSnapshot2.getColor());
                g.setColor(bulletColor);
                g.fill(bulletArea);
                continue;
            }
            if (!this.drawExplosions) continue;
            if (!IBulletSnapshot2.isExplosion()) {
                scale = Math.sqrt(1000.0 * IBulletSnapshot2.getPower()) / 128.0;
                at.scale(scale, scale);
            }
            RenderImage explosionRenderImage = this.imageManager.getExplosionRenderImage(IBulletSnapshot2.getExplosionImageIndex(), IBulletSnapshot2.getFrame());
            explosionRenderImage.setTransform(at);
            explosionRenderImage.paint(g);
        }
        g.setClip(savedClip);
    }

    private void centerString(Graphics2D g, String s, int x, int y, Font font, FontMetrics fm) {
        g.setFont(font);
        int width = fm.stringWidth(s);
        int height = fm.getHeight();
        int descent = fm.getDescent();
        double left = x - width / 2;
        double top = y - height / 2;
        double scaledViewWidth = (double)this.getWidth() / this.scale;
        double scaledViewHeight = (double)this.getHeight() / this.scale;
        double borderWidth = (scaledViewWidth - (double)this.battleField.getWidth()) / 2.0;
        double borderHeight = (scaledViewHeight - (double)this.battleField.getHeight()) / 2.0;
        if (left + (double)width > scaledViewWidth) {
            left = scaledViewWidth - (double)width;
        }
        if (top + (double)height > scaledViewHeight) {
            top = scaledViewHeight - (double)height;
        }
        if (left < -borderWidth) {
            left = -borderWidth;
        }
        if (top < -borderHeight) {
            top = -borderHeight;
        }
        g.drawString(s, (int)(left + 0.5), (int)(top + (double)height - (double)descent + 0.5));
    }

    private void drawScanArc(Graphics2D g, IRobotSnapshot robotSnapshot) {
        Arc2D.Double scanArc = (Arc2D.Double)((RobotSnapshot)robotSnapshot).getScanArc();
        if (scanArc == null) {
            return;
        }
        Composite savedComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.2f));
        scanArc.setAngleStart((360.0 - scanArc.getAngleStart() - scanArc.getAngleExtent()) % 360.0);
        scanArc.y = (double)this.battleField.getHeight() - robotSnapshot.getY() - 1200.0;
        int scanColor = robotSnapshot.getScanColor();
        g.setColor(new Color(scanColor, true));
        if (Math.abs(scanArc.getAngleExtent()) >= 0.5) {
            g.fill(scanArc);
        } else {
            g.draw(scanArc);
        }
        g.setComposite(savedComposite);
    }

    private void paintRobocodeLogo(Graphics2D g) {
        this.setBackground(Color.BLACK);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.transform(AffineTransform.getTranslateInstance((double)(this.getWidth() - 320) / 2.0, (double)(this.getHeight() - 46) / 2.0));
        g.setColor(new Color(0, 64, 0));
        g.fill(this.robocodeTextPath);
        Font font = new Font("Dialog", 1, 14);
        int width = g.getFontMetrics(font).stringWidth(ROBOCODE_SLOGAN);
        g.setTransform(new AffineTransform());
        g.setFont(font);
        g.setColor(new Color(0, 80, 0));
        g.drawString(ROBOCODE_SLOGAN, (float)((double)(this.getWidth() - width) / 2.0), (float)((double)this.getHeight() / 2.0 + 50.0));
    }

    static /* synthetic */ IGraphicsProxy[] access$302(BattleView x0, IGraphicsProxy[] x1) {
        x0.robotGraphics = x1;
        return x1;
    }

    private class BattleObserver
    extends BattleAdaptor {
        public BattleObserver(IWindowManager windowManager) {
            windowManager.addBattleListener((IBattleListener)this);
        }

        public void onBattleStarted(BattleStartedEvent event) {
            BattleView.this.battleField = new BattleField(event.getBattleRules().getBattlefieldWidth(), event.getBattleRules().getBattlefieldHeight());
            BattleView.this.initialized = false;
            BattleView.this.setVisible(true);
            super.onBattleStarted(event);
            BattleView.access$302(BattleView.this, new IGraphicsProxy[event.getRobotsCount()]);
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            super.onBattleFinished(event);
            BattleView.access$302(BattleView.this, null);
        }

        public void onTurnEnded(TurnEndedEvent event) {
            if (event.getTurnSnapshot() == null) {
                BattleView.this.repaint();
            } else {
                BattleView.this.update(event.getTurnSnapshot());
            }
        }
    }
}

