/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.battleview;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import net.sf.robocode.io.FileUtil;

public class ScreenshotUtil {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveScreenshot(BufferedImage screenshot, String format, float compressionQuality) {
        FileImageOutputStream output = null;
        ImageWriter writer = null;
        File screenshotDir = FileUtil.getScreenshotsDir();
        FileUtil.createDir((File)screenshotDir);
        File file = new File(screenshotDir, DATE_FORMAT.format(new Date()) + '.' + format.toLowerCase());
        try {
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(format);
            writer = it.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            if (iwp.canWriteCompressed()) {
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(compressionQuality);
            }
            output = new FileImageOutputStream(file);
            writer.setOutput(output);
            IIOImage image = new IIOImage(screenshot, null, null);
            writer.write(null, image, iwp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

