/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.dialog.RobocodeFrame;
import net.sf.robocode.version.IVersionManager;

public final class AboutBox
extends JDialog {
    private static final Color BG_COLOR = SystemColor.controlHighlight;
    private static final String TAG_ROBOCODE_VERSION = "<robocode:version>";
    private static final String TAG_ROBOCODE_ICON_SRC = "<robocode:icon-src>";
    private static final String TAG_SYSCOLOR_CTRL_HIGHLIGHT = "<syscolor:ctrl-highlight>";
    private static final String TAG_JAVA_VERSION = "<java:version>";
    private static final String TAG_JAVA_VENDOR = "<java:vendor>";
    private static final String HTML_TEMPLATE = "<head><style type=\"text/css\">p, td {font-family: sans-serif; font-size: 10px}</style></head><body bgcolor=\"<syscolor:ctrl-highlight>\"><table width=\"600 px\"><tr><td valign=\"top\"><img src=\"<robocode:icon-src>\"></td><td><table width=\"100%\"><tr><td><b>Robocode</b><br><br>&copy;&nbsp;Copyright 2001, 2009<br>Mathew A. Nelson and Robocode contributors</td><td align=\"right\"><b>Version: <robocode:version></b><br><br><a href=\"http://robocode.sourceforge.net\">Robocode Home</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href=\"http://robowiki.net\">RoboWiki</a><br>&nbsp;</td></tr></table><center><b>Original Author</b><br>Designed and programmed by <b><font color=\"green\">Mathew A. Nelson</font></b><br>Graphics by <b><font color=\"green\">Garett S. Hourihan</font></b><br><br><b>Featuring the <a href=\"http://robowiki.net/wiki/RoboRumble\">RoboRumble@Home</a> client</b><br>Originally designed and programmed by <b><font color=\"green\">Albert P\u00e9rez</font></b><br><br><b>Main Contributors:</b><br><b><font color=\"green\">Flemming N. Larsen</font></b> (Robocode administrator, developer, integrator, lots of features),<br><b><font color=\"green\">Pavel Savara</font></b> (Robocode administrator, developer, integrator, robot interfaces, battle events, refactorings),<br><br><b>Other Contributors:</b><br><b><font color=\"green\">Cubic Creative</font></b> (the design and ideas for the JuniorRobot class), <b><font color=\"green\">Christian D. Schnell</font></b> (for the Codesize utility), <b><font color=\"green\">Luis Crespo</font></b> (sound engine, single-step debugging, ranking panel), <b><font color=\"green\">Matthew Reeder</font></b> (editor enhancements, keyboard shortcuts, HyperThreading bugfixes), <b><font color=\"green\">Titus Chen</font></b> (bugfixes for robot teleportation, bad wall collision detection, team ranking, replay scores and robot color flickering), <b><font color=\"green\">Robert D. Maupin</font></b> (optimizations with collections and improved CPU constant benchmark), <b><font color=\"green\">Ascander Jr</font></b> (graphics for ground tiles), <b><font color=\"green\">Stefan Westen</font></b> (onPaint method from RobocodeSG), <b><font color=\"green\">Nathaniel Troutman</font></b> (fixing memory leaks due to circular references), <b><font color=\"green\">Aaron Rotenberg</font></b> (for the Robot Cache Cleaner utility), <b><font color=\"green\">Julian Kent</font></b> (nano precision timing of allowed robot time), <b><font color=\"green\">Joachim Hofer</font></b> (fixing problem with wrong results in RoboRumble), <b><font color=\"green\">Endre Palatinus, Eniko Nagy, Attila Csizofszki and Laszlo Vigh</font></b> (score % in results/rankings), <b><font color=\"green\">Jerome Lavigne</font></b> (added \"Smart Battles\" to MeleeRumble), <b><font color=\"green\">Ruben Moreno Montoliu</font></b> (added list paths with buttons to Developement Options), <b><font color=\"green\">Joshua Galecki</font></b> (the implementation of the RateControlRobot), <b><font color=\"green\">Patrick Cupka, Julian Kent, Nat Pavasant and \"Positive\"</font></b> (new robot movement method)<br><br><b>Java Runtime Environment</b><br>Java <java:version> by <java:vendor></center></td></tr></table></body>";
    private final String robocodeVersion;
    private final URL iconURL;
    private JPanel aboutBoxContentPane;
    private JEditorPane mainPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private String htmlText;
    private final transient ActionListener eventHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AboutBox.this.getOkButton()) {
                AboutBox.this.dispose();
            }
        }
    };
    private final transient HyperlinkListener hyperlinkHandler = new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    BrowserManager.openURL(event.getURL().toExternalForm());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public AboutBox(RobocodeFrame owner, IVersionManager versionManager) {
        super((Frame)owner, true);
        this.robocodeVersion = versionManager.getVersion();
        this.iconURL = AboutBox.class.getResource("/net/sf/robocode/ui/icons/robocode-icon.png");
        this.setDefaultCloseOperation(2);
        this.setTitle("About Robocode");
        this.setContentPane(this.getAboutBoxContentPane());
        this.setResizable(false);
    }

    private JPanel getAboutBoxContentPane() {
        if (this.aboutBoxContentPane == null) {
            this.aboutBoxContentPane = new JPanel();
            this.aboutBoxContentPane.setLayout(new BorderLayout());
            this.aboutBoxContentPane.add((Component)this.getButtonPanel(), "South");
            this.aboutBoxContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.aboutBoxContentPane;
    }

    private JEditorPane getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JEditorPane("text/html; charset=ISO-8859-1", this.getHtmlText());
            this.mainPanel.setBackground(BG_COLOR);
            this.mainPanel.setEditable(false);
            this.mainPanel.addHyperlinkListener(this.hyperlinkHandler);
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBackground(BG_COLOR);
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add(this.getOkButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this.eventHandler);
        }
        return this.okButton;
    }

    private String getHtmlText() {
        if (this.htmlText == null) {
            this.htmlText = HTML_TEMPLATE.replaceAll(TAG_ROBOCODE_VERSION, this.robocodeVersion).replaceAll(TAG_ROBOCODE_ICON_SRC, this.iconURL.toString()).replaceAll(TAG_SYSCOLOR_CTRL_HIGHLIGHT, AboutBox.toHtmlColor(BG_COLOR)).replaceAll(TAG_JAVA_VERSION, AboutBox.getJavaVersion()).replaceAll(TAG_JAVA_VENDOR, System.getProperty("java.vendor"));
        }
        return this.htmlText;
    }

    private static String toHtmlColor(Color color) {
        return "#" + AboutBox.toHexDigits(color.getRed()) + AboutBox.toHexDigits(color.getGreen()) + AboutBox.toHexDigits(color.getBlue());
    }

    private static String toHexDigits(int value) {
        return "" + AboutBox.toHexDigit(value >> 4) + AboutBox.toHexDigit(value & 0xF);
    }

    private static char toHexDigit(int value) {
        int v = value & 0xF;
        if (v < 10) {
            return (char)(48 + v);
        }
        return (char)(65 + (v - 10));
    }

    private static String getJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String javaArchModel = System.getProperty("sun.arch.data.model");
        if (javaArchModel != null) {
            try {
                int numBits = Integer.parseInt(javaArchModel);
                javaVersion = javaVersion + " (" + numBits + "-bit)";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return javaVersion;
    }
}

