/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.robocode.io.Logger;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlWriter;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.ConsoleScrollPane;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.ITurnSnapshot;

public class BattleDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final BattleObserver battleObserver = new BattleObserver();
    private ConsoleScrollPane consoleScrollPane;
    private ConsoleScrollPane turnSnapshotScrollPane;
    private JTabbedPane tabbedPane;
    private JButton okButton;
    private JButton clearButton;
    private JPanel battleDialogContentPane;
    private JPanel buttonPanel;
    private final IWindowManager windowManager;
    private boolean isListening;
    private ITurnSnapshot lastSnapshot;
    private boolean paintSnapshot;
    private final transient ActionListener eventHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == BattleDialog.this.getOkButton()) {
                BattleDialog.this.okButtonActionPerformed();
            } else if (src == BattleDialog.this.getClearButton()) {
                BattleDialog.this.clearButtonActionPerformed();
            }
        }
    };

    public BattleDialog(IWindowManager windowManager) {
        this.windowManager = windowManager;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Main battle log");
        this.add(this.getBattleDialogContentPane());
        this.pack();
    }

    public void detach() {
        if (this.isListening) {
            this.windowManager.removeBattleListener((IBattleListener)this.battleObserver);
            this.isListening = false;
        }
    }

    public void reset() {
        this.getConsoleScrollPane().setText(null);
        this.getTurnSnapshotScrollPane().setText(null);
        this.lastSnapshot = null;
    }

    public void attach() {
        if (!this.isListening) {
            this.isListening = true;
            this.windowManager.addBattleListener((IBattleListener)this.battleObserver);
        }
    }

    public void pack() {
        this.getConsoleScrollPane().setPreferredSize(new Dimension(426, 200));
        super.pack();
        this.getTabbedPane().setPreferredSize(null);
    }

    private JPanel getBattleDialogContentPane() {
        if (this.battleDialogContentPane == null) {
            this.battleDialogContentPane = new JPanel();
            this.battleDialogContentPane.setLayout(new BorderLayout());
            this.battleDialogContentPane.add(this.getTabbedPane());
            this.battleDialogContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.battleDialogContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(0));
            this.buttonPanel.add(this.getOkButton());
            this.buttonPanel.add(this.getClearButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = this.getNewButton("OK");
        }
        return this.okButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = this.getNewButton("Clear");
        }
        return this.clearButton;
    }

    private JButton getNewButton(String text) {
        JButton button = new JButton(text);
        button.addActionListener(this.eventHandler);
        return button;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setLayout(new BorderLayout());
            this.tabbedPane.addTab("Console", this.getConsoleScrollPane());
            this.tabbedPane.addTab("Turn Snapshot", this.getTurnSnapshotScrollPane());
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    BattleDialog.this.paintSnapshot = BattleDialog.this.tabbedPane.getSelectedIndex() == 1;
                    BattleDialog.this.paintSnapshot();
                }
            });
        }
        return this.tabbedPane;
    }

    private ConsoleScrollPane getConsoleScrollPane() {
        if (this.consoleScrollPane == null) {
            this.consoleScrollPane = new ConsoleScrollPane();
        }
        return this.consoleScrollPane;
    }

    private ConsoleScrollPane getTurnSnapshotScrollPane() {
        if (this.turnSnapshotScrollPane == null) {
            this.turnSnapshotScrollPane = new ConsoleScrollPane();
        }
        return this.turnSnapshotScrollPane;
    }

    private void okButtonActionPerformed() {
        this.dispose();
    }

    private void clearButtonActionPerformed() {
        this.reset();
    }

    private void paintSnapshot() {
        if (this.paintSnapshot) {
            String text = null;
            if (this.lastSnapshot != null) {
                StringWriter writer = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)writer, true);
                try {
                    ((IXmlSerializable)this.lastSnapshot).writeXml(xmlWriter, null);
                    writer.close();
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e);
                }
                text = writer.toString();
            }
            this.getTurnSnapshotScrollPane().setText(text);
        }
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onBattleMessage(BattleMessageEvent event) {
            String text = event.getMessage();
            if (text != null && text.length() > 0) {
                BattleDialog.this.getConsoleScrollPane().append(text + "\n");
                BattleDialog.this.getConsoleScrollPane().scrollToBottom();
            }
        }

        public void onBattleError(BattleErrorEvent event) {
            String text = event.getError();
            if (text != null && text.length() > 0) {
                BattleDialog.this.getConsoleScrollPane().append(text + "\n");
                BattleDialog.this.getConsoleScrollPane().scrollToBottom();
            }
        }

        public void onTurnEnded(TurnEndedEvent event) {
            BattleDialog.this.lastSnapshot = event.getTurnSnapshot();
            BattleDialog.this.paintSnapshot();
        }

        public void onBattleStarted(BattleStartedEvent event) {
            BattleDialog.this.reset();
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            BattleDialog.this.lastSnapshot = null;
            BattleDialog.this.paintSnapshot();
        }
    }
}

