/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class ConsoleScrollPane
extends JScrollPane {
    private static final int MAX_ROWS = 500;
    private static final String TEXT_TRUNCATED_MSG = "^^^ TEXT TRUNCATED ^^^";
    private JTextArea textArea;
    private int lines;
    private int maxRows;

    public ConsoleScrollPane() {
        this.setViewportView(this.getTextPane());
    }

    public JTextArea getTextPane() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            this.textArea.setTabSize(4);
            this.textArea.setBackground(Color.DARK_GRAY);
            this.textArea.setForeground(Color.WHITE);
            this.textArea.setBounds(0, 0, 1000, 1000);
            ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        }
        return this.textArea;
    }

    public void append(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        this.getTextPane().append(str);
        int numNewLines = str.replaceAll("[^\\n]", "").length();
        this.lines += numNewLines;
        int linesExceeded = this.lines - 500;
        if (linesExceeded > 0) {
            this.lines = 500;
            String text = this.getText();
            int cutIndex = -1;
            for (int c = 0; c < linesExceeded; ++c) {
                cutIndex = text.indexOf(10, cutIndex + 1);
            }
            this.textArea.replaceRange(null, 0, cutIndex + 1);
            this.textArea.replaceRange(TEXT_TRUNCATED_MSG, 0, this.getText().indexOf(10));
        }
        this.maxRows = Math.max(this.maxRows, this.lines);
        this.textArea.setRows(this.maxRows);
    }

    public String getSelectedText() {
        return this.getTextPane().getSelectedText();
    }

    public String getText() {
        return this.getTextPane().getText();
    }

    public void setText(String t) {
        if (t == null || t.length() == 0) {
            t = null;
            this.lines = 0;
            this.maxRows = 0;
        } else {
            this.lines = t.replaceAll("[^\\n]", "").length();
            int linesExceeded = this.lines - 500;
            if (linesExceeded > 0) {
                this.lines = 500;
                int index = -1;
                for (int c = 0; c < linesExceeded; ++c) {
                    index = t.indexOf(10, index + 1);
                }
                t = t.substring(index + 1);
                t = TEXT_TRUNCATED_MSG + t.substring(t.indexOf(10) + 1);
            }
        }
        this.textArea.setText(t);
        this.maxRows = Math.max(this.maxRows, this.lines);
        this.textArea.setRows(this.maxRows);
    }

    public void processStream(InputStream input) {
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                this.append(line + "\n");
            }
        }
        catch (IOException e) {
            this.append("SYSTEM: IOException: " + e);
        }
        this.scrollToBottom();
    }

    public void scrollToBottom() {
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }
}

