/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewBattleBattleFieldTab
extends JPanel {
    private static final int MIN_SIZE = 400;
    private static final int MAX_SIZE = 5000;
    private static final int STEP_SIZE = 100;
    private final EventHandler eventHandler = new EventHandler();
    private final SizeButton[] sizeButtons = new SizeButton[]{new SizeButton(400, 400), new SizeButton(600, 400), new SizeButton(600, 600), new SizeButton(800, 600), new SizeButton(800, 800), new SizeButton(1000, 800), new SizeButton(1000, 1000), new SizeButton(1200, 1200), new SizeButton(2000, 2000), new SizeButton(5000, 5000)};
    private final JSlider battleFieldWidthSlider = this.createBattleFieldWidthSlider();
    private final JSlider battleFieldHeightSlider = this.createBattleFieldHeightSlider();
    private final JLabel battleFieldSizeLabel = this.createBattleFieldSizeLabel();

    public NewBattleBattleFieldTab() {
        JPanel sliderPanel = this.createSliderPanel();
        this.add(sliderPanel);
        JPanel buttonsPanel = this.createButtonsPanel();
        this.add(buttonsPanel);
    }

    public int getBattleFieldWidth() {
        return this.battleFieldWidthSlider.getValue();
    }

    public void setBattleFieldWidth(int width) {
        this.battleFieldWidthSlider.setValue(width);
        this.battleFieldSliderValuesChanged();
    }

    public int getBattleFieldHeight() {
        return this.battleFieldHeightSlider.getValue();
    }

    public void setBattleFieldHeight(int height) {
        this.battleFieldHeightSlider.setValue(height);
        this.battleFieldSliderValuesChanged();
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Default Sizes"));
        panel.setLayout(new GridLayout(this.sizeButtons.length, 1));
        for (SizeButton button : this.sizeButtons) {
            panel.add(button);
        }
        return panel;
    }

    private JPanel createSliderPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Battlefield Size"));
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.battleFieldHeightSlider, "East");
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BorderLayout());
        subPanel.add((Component)this.battleFieldWidthSlider, "South");
        subPanel.add((Component)this.battleFieldSizeLabel, "Center");
        panel.add((Component)subPanel, "Center");
        return panel;
    }

    private JSlider createBattleFieldWidthSlider() {
        JSlider slider = new JSlider();
        slider.setMinimum(400);
        slider.setMaximum(5000);
        slider.setMajorTickSpacing(100);
        slider.setSnapToTicks(true);
        slider.addChangeListener(this.eventHandler);
        return slider;
    }

    private JSlider createBattleFieldHeightSlider() {
        JSlider slider = this.createBattleFieldWidthSlider();
        slider.setOrientation(1);
        return slider;
    }

    private JLabel createBattleFieldSizeLabel() {
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        return label;
    }

    private void battleFieldSliderValuesChanged() {
        int w = this.battleFieldWidthSlider.getValue();
        int h = this.battleFieldHeightSlider.getValue();
        this.battleFieldSizeLabel.setText(w + " x " + h);
    }

    private class EventHandler
    implements ActionListener,
    ChangeListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof SizeButton) {
                SizeButton button = (SizeButton)e.getSource();
                NewBattleBattleFieldTab.this.battleFieldWidthSlider.setValue(button.width);
                NewBattleBattleFieldTab.this.battleFieldHeightSlider.setValue(button.height);
                NewBattleBattleFieldTab.this.battleFieldSliderValuesChanged();
            }
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == NewBattleBattleFieldTab.this.battleFieldWidthSlider || e.getSource() == NewBattleBattleFieldTab.this.battleFieldHeightSlider) {
                NewBattleBattleFieldTab.this.battleFieldSliderValuesChanged();
            }
        }
    }

    private class SizeButton
    extends JButton {
        final int width;
        final int height;

        public SizeButton(int width, int height) {
            super(width + "x" + height);
            this.width = width;
            this.height = height;
            this.addActionListener(NewBattleBattleFieldTab.this.eventHandler);
        }
    }
}

