/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesDevelopmentOptionsTab
extends WizardPanel {
    private JPanel optionsPanel;
    private JButton addButton;
    private JButton removeButton;
    private JList pathList;
    public final ISettingsManager properties;
    private final EventHandler eventHandler = new EventHandler();

    public PreferencesDevelopmentOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getOptionsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Development"));
            GridBagLayout layout = new GridBagLayout();
            this.optionsPanel.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 5, 5);
            c.anchor = 18;
            c.fill = 2;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.gridy = 1;
            this.optionsPanel.add((Component)new JLabel("If you are using an external IDE to develop robots, you may enter the classpath to those robots here."), c);
            c.gridy = 2;
            this.optionsPanel.add((Component)new JLabel("If you are using Eclipse, you can enter paths to robot projects inside a workspace as well (recommended)"), c);
            c.gridwidth = 1;
            c.gridy = 3;
            c.insets = new Insets(3, 3, 3, 3);
            this.optionsPanel.add((Component)this.getAddButton(), c);
            c.gridy = 4;
            this.optionsPanel.add((Component)this.getRemoveButton(), c);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 1;
            c.gridy = 3;
            c.gridheight = 3;
            c.insets = new Insets(5, 5, 5, 5);
            JScrollPane pathListScroller = new JScrollPane(this.getPathList());
            this.optionsPanel.add((Component)pathListScroller, c);
        }
        return this.optionsPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton("Add");
            this.addButton.setDisplayedMnemonicIndex(2);
            this.addButton.addActionListener(this.eventHandler);
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton("Remove");
            this.removeButton.setDisplayedMnemonicIndex(3);
            this.removeButton.addActionListener(this.eventHandler);
        }
        return this.removeButton;
    }

    private JList getPathList() {
        if (this.pathList == null) {
            this.pathList = new JList(new DefaultListModel());
            this.pathList.setSelectionMode(2);
            this.pathList.setLayoutOrientation(0);
            this.pathList.setVisibleRowCount(-1);
            this.pathList.addListSelectionListener(this.eventHandler);
        }
        return this.pathList;
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        DefaultListModel model = this.getDefaultListModel();
        model.clear();
        StringTokenizer tokenizer = new StringTokenizer(robocodeProperties.getOptionsDevelopmentPath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            model.addElement(tokenizer.nextToken());
        }
        this.updateRemoveButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePreferences() {
        String oldPaths = this.properties.getOptionsDevelopmentPath();
        String newPaths = "";
        DefaultListModel model = this.getDefaultListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            newPaths = newPaths + model.getElementAt(i) + File.pathSeparator;
        }
        this.properties.setOptionsDevelopmentPath(newPaths);
        this.properties.saveProperties();
        if (!newPaths.equals(oldPaths)) {
            String[] paths;
            boolean forceRebuild = false;
            for (String path : paths = oldPaths.split("\\" + File.pathSeparator)) {
                if (path.length() <= 0 || model.contains(path)) continue;
                forceRebuild = true;
                break;
            }
            IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
            try {
                windowManager.setBusyPointer(true);
                ((IRepositoryManager)Container.getComponent(IRepositoryManager.class)).reload(forceRebuild);
            }
            finally {
                windowManager.setBusyPointer(false);
            }
        }
    }

    public boolean isReady() {
        return true;
    }

    private DefaultListModel getDefaultListModel() {
        return (DefaultListModel)this.getPathList().getModel();
    }

    private void updateRemoveButton() {
        this.getRemoveButton().setEnabled(this.getPathList().getSelectedIndex() >= 0);
    }

    private void sort() {
        DefaultListModel model = this.getDefaultListModel();
        int size = model.getSize();
        if (size > 0) {
            Object[] items = new String[size];
            model.copyInto(items);
            Arrays.sort(items);
            for (int i = 0; i < items.length; ++i) {
                model.setElementAt(items[i], i);
            }
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PreferencesDevelopmentOptionsTab.this.getAddButton()) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                if (chooser.showOpenDialog(PreferencesDevelopmentOptionsTab.this.optionsPanel) == 0) {
                    String path = chooser.getSelectedFile().getAbsolutePath();
                    DefaultListModel model = PreferencesDevelopmentOptionsTab.this.getDefaultListModel();
                    if (!model.contains(path)) {
                        ((DefaultListModel)PreferencesDevelopmentOptionsTab.this.getPathList().getModel()).addElement(path);
                        PreferencesDevelopmentOptionsTab.this.sort();
                    }
                }
                PreferencesDevelopmentOptionsTab.this.updateRemoveButton();
            } else if (e.getSource() == PreferencesDevelopmentOptionsTab.this.getRemoveButton()) {
                DefaultListModel model = PreferencesDevelopmentOptionsTab.this.getDefaultListModel();
                int[] indices = PreferencesDevelopmentOptionsTab.this.getPathList().getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    model.remove(i);
                }
                PreferencesDevelopmentOptionsTab.this.updateRemoveButton();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            PreferencesDevelopmentOptionsTab.this.updateRemoveButton();
        }
    }
}

