/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IImageManager;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesRenderingOptionsTab
extends WizardPanel {
    private final ISettingsManager properties;
    private JPanel specificSettingsPanel;
    private JPanel predefinedSettingsPanel;
    private JPanel otherSettingsPanel;
    private JComboBox optionsRenderingAntialiasingComboBox;
    private JComboBox optionsRenderingTextAntialiasingComboBox;
    private JComboBox optionsRenderingMethodComboBox;
    private JComboBox optionsRenderingNoBuffersComboBox;
    private JCheckBox optionsRenderingBufferImagesCheckBox;
    private JCheckBox optionsRenderingForceBulletColorCheckBox;
    private JButton predefinedPlaformDefaultButton;
    private JButton predefinedSpeedButton;
    private JButton predefinedQualityButton;
    private EventHandler eventHandler;
    private final IImageManager imageManager;

    public PreferencesRenderingOptionsTab(ISettingsManager properties, IImageManager imageManager) {
        this.properties = properties;
        this.imageManager = imageManager;
        this.initialize();
    }

    private void initialize() {
        this.eventHandler = new EventHandler();
        this.setLayout(new GridLayout(1, 3));
        this.add(this.getSpecificSettingsPanel());
        this.add(this.getPredefinedSettingsPanel());
        this.add(this.getOtherSettingsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getSpecificSettingsPanel() {
        if (this.specificSettingsPanel == null) {
            this.specificSettingsPanel = new JPanel();
            this.specificSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Specific settings"));
            this.specificSettingsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            c.anchor = 19;
            c.weightx = 0.0;
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = 0;
            this.specificSettingsPanel.add((Component)new JLabel("Set individual rendering options:"), c);
            c.gridwidth = 1;
            c.gridy = 1;
            this.specificSettingsPanel.add((Component)new JLabel("Antialiasing", 4), c);
            c.gridx = 1;
            this.specificSettingsPanel.add((Component)this.getOptionsRenderingAntialiasingComboBox(), c);
            c.gridx = 0;
            c.gridy = 2;
            this.specificSettingsPanel.add((Component)new JLabel("Text Antialiasing", 4), c);
            c.gridx = 1;
            this.specificSettingsPanel.add((Component)this.getOptionsRenderingTextAntialiasingComboBox(), c);
            c.gridx = 0;
            c.gridy = 3;
            this.specificSettingsPanel.add((Component)new JLabel("Rendering Method", 4), c);
            c.gridx = 1;
            this.specificSettingsPanel.add((Component)this.getOptionsRenderingMethodComboBox(), c);
            c.gridx = 0;
            c.gridy = 4;
            this.specificSettingsPanel.add((Component)new JLabel(" "), c);
            c.gridx = 0;
            c.gridy = 5;
            this.specificSettingsPanel.add((Component)new JLabel("Number of buffers", 4), c);
            c.gridx = 1;
            this.specificSettingsPanel.add((Component)this.getOptionsRenderingNoBuffersComboBox(), c);
        }
        return this.specificSettingsPanel;
    }

    private JPanel getPredefinedSettingsPanel() {
        if (this.predefinedSettingsPanel == null) {
            this.predefinedSettingsPanel = new JPanel();
            this.predefinedSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Predefined settings"));
            this.predefinedSettingsPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            c.anchor = 19;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            this.predefinedSettingsPanel.add((Component)new JLabel("Set all rendering settings towards:"), c);
            c.weightx = 0.3333333432674408;
            c.gridwidth = 1;
            c.gridy = 2;
            this.predefinedSettingsPanel.add((Component)this.getPredefinedPlatformDefaultButton(), c);
            c.gridx = 1;
            this.predefinedSettingsPanel.add((Component)this.getPredefinedSpeedButton(), c);
            c.gridx = 2;
            this.predefinedSettingsPanel.add((Component)this.getPredefinedQualityButton(), c);
        }
        return this.predefinedSettingsPanel;
    }

    private JPanel getOtherSettingsPanel() {
        if (this.otherSettingsPanel == null) {
            this.otherSettingsPanel = new JPanel();
            this.otherSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Other settings"));
            this.otherSettingsPanel.setLayout(new BoxLayout(this.otherSettingsPanel, 1));
            this.otherSettingsPanel.add(this.getOptionsRenderingBufferImagesCheckBox());
            this.otherSettingsPanel.add(this.getOptionsRenderingForceBulletColorCheckBox());
        }
        return this.otherSettingsPanel;
    }

    private JComboBox getOptionsRenderingAntialiasingComboBox() {
        if (this.optionsRenderingAntialiasingComboBox == null) {
            this.optionsRenderingAntialiasingComboBox = new JComboBox<String>(new String[]{"Default", "On", "Off"});
            this.optionsRenderingAntialiasingComboBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingAntialiasingComboBox;
    }

    private JComboBox getOptionsRenderingTextAntialiasingComboBox() {
        if (this.optionsRenderingTextAntialiasingComboBox == null) {
            this.optionsRenderingTextAntialiasingComboBox = new JComboBox<String>(new String[]{"Default", "On", "Off"});
            this.optionsRenderingTextAntialiasingComboBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingTextAntialiasingComboBox;
    }

    private JComboBox getOptionsRenderingMethodComboBox() {
        if (this.optionsRenderingMethodComboBox == null) {
            this.optionsRenderingMethodComboBox = new JComboBox<String>(new String[]{"Default", "Quality", "Speed"});
            this.optionsRenderingMethodComboBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingMethodComboBox;
    }

    private JComboBox getOptionsRenderingNoBuffersComboBox() {
        if (this.optionsRenderingNoBuffersComboBox == null) {
            this.optionsRenderingNoBuffersComboBox = new JComboBox<String>(new String[]{"Single buffering", "Double buffering", "Triple buffering"});
            this.optionsRenderingNoBuffersComboBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingNoBuffersComboBox;
    }

    private JButton getPredefinedPlatformDefaultButton() {
        if (this.predefinedPlaformDefaultButton == null) {
            this.predefinedPlaformDefaultButton = new JButton("Default");
            this.predefinedPlaformDefaultButton.setMnemonic('u');
            this.predefinedPlaformDefaultButton.setDisplayedMnemonicIndex(4);
            this.predefinedPlaformDefaultButton.addActionListener(this.eventHandler);
        }
        return this.predefinedPlaformDefaultButton;
    }

    private JButton getPredefinedSpeedButton() {
        if (this.predefinedSpeedButton == null) {
            this.predefinedSpeedButton = new JButton("Speed");
            this.predefinedSpeedButton.setMnemonic('p');
            this.predefinedSpeedButton.setDisplayedMnemonicIndex(1);
            this.predefinedSpeedButton.addActionListener(this.eventHandler);
        }
        return this.predefinedSpeedButton;
    }

    private JButton getPredefinedQualityButton() {
        if (this.predefinedQualityButton == null) {
            this.predefinedQualityButton = new JButton("Quality");
            this.predefinedQualityButton.setMnemonic('Q');
            this.predefinedQualityButton.addActionListener(this.eventHandler);
        }
        return this.predefinedQualityButton;
    }

    private JCheckBox getOptionsRenderingBufferImagesCheckBox() {
        if (this.optionsRenderingBufferImagesCheckBox == null) {
            this.optionsRenderingBufferImagesCheckBox = new JCheckBox("Buffer images (uses memory)");
            this.optionsRenderingBufferImagesCheckBox.setMnemonic('i');
            this.optionsRenderingBufferImagesCheckBox.setDisplayedMnemonicIndex(7);
            this.optionsRenderingBufferImagesCheckBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingBufferImagesCheckBox;
    }

    private JCheckBox getOptionsRenderingForceBulletColorCheckBox() {
        if (this.optionsRenderingForceBulletColorCheckBox == null) {
            this.optionsRenderingForceBulletColorCheckBox = new JCheckBox("Make all bullets white");
            this.optionsRenderingForceBulletColorCheckBox.setMnemonic('M');
            this.optionsRenderingForceBulletColorCheckBox.addActionListener(this.eventHandler);
        }
        return this.optionsRenderingForceBulletColorCheckBox;
    }

    private void loadPreferences(ISettingsManager props) {
        this.getOptionsRenderingAntialiasingComboBox().setSelectedIndex(props.getOptionsRenderingAntialiasing());
        this.getOptionsRenderingTextAntialiasingComboBox().setSelectedIndex(props.getOptionsRenderingTextAntialiasing());
        this.getOptionsRenderingMethodComboBox().setSelectedIndex(props.getOptionsRenderingMethod());
        this.getOptionsRenderingNoBuffersComboBox().setSelectedIndex(props.getOptionsRenderingNoBuffers() - 1);
        this.getOptionsRenderingBufferImagesCheckBox().setSelected(props.getOptionsRenderingBufferImages());
        this.getOptionsRenderingForceBulletColorCheckBox().setSelected(props.getOptionsRenderingForceBulletColor());
    }

    public void storePreferences() {
        ISettingsManager props = this.properties;
        props.setOptionsRenderingAntialiasing(this.optionsRenderingAntialiasingComboBox.getSelectedIndex());
        props.setOptionsRenderingTextAntialiasing(this.optionsRenderingTextAntialiasingComboBox.getSelectedIndex());
        props.setOptionsRenderingMethod(this.optionsRenderingMethodComboBox.getSelectedIndex());
        props.setOptionsRenderingNoBuffers(this.optionsRenderingNoBuffersComboBox.getSelectedIndex() + 1);
        props.setOptionsRenderingBufferImages(this.optionsRenderingBufferImagesCheckBox.isSelected());
        props.setOptionsRenderingForceBulletColor(this.optionsRenderingForceBulletColorCheckBox.isSelected());
        this.properties.saveProperties();
    }

    public boolean isReady() {
        return true;
    }

    private void setPredefinedSettings(int index) {
        this.optionsRenderingAntialiasingComboBox.setSelectedIndex(index);
        this.optionsRenderingTextAntialiasingComboBox.setSelectedIndex(index);
        this.optionsRenderingMethodComboBox.setSelectedIndex(index);
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == PreferencesRenderingOptionsTab.this.predefinedPlaformDefaultButton) {
                PreferencesRenderingOptionsTab.this.setPredefinedSettings(0);
            } else if (src == PreferencesRenderingOptionsTab.this.predefinedQualityButton) {
                PreferencesRenderingOptionsTab.this.setPredefinedSettings(1);
            } else if (src == PreferencesRenderingOptionsTab.this.predefinedSpeedButton) {
                PreferencesRenderingOptionsTab.this.setPredefinedSettings(2);
            } else if (src == PreferencesRenderingOptionsTab.this.optionsRenderingBufferImagesCheckBox) {
                new Thread(){

                    public void run() {
                        PreferencesRenderingOptionsTab.this.storePreferences();
                        PreferencesRenderingOptionsTab.this.imageManager.initialize();
                    }
                }.start();
                return;
            }
        }
    }
}

