/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import net.sf.robocode.battle.BattleRankingTableModel;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.BaseScoreDialog;
import net.sf.robocode.ui.dialog.MenuBar;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.ITurnSnapshot;

public class RankingDialog
extends BaseScoreDialog {
    private final BattleRankingTableModel tableModel;
    private final Timer timerTask;
    private final BattleObserver battleObserver;
    private final AtomicReference<ITurnSnapshot> snapshot;
    private ITurnSnapshot lastSnapshot;
    private int lastRows;
    private final MenuBar menu;
    private final IWindowManager windowManager;

    public RankingDialog(IWindowManager windowManager, ISettingsManager settingsManager, MenuBar menu) {
        super(settingsManager.getOptionsCommonDontHideRankings() ? null : windowManager, false);
        this.initialize();
        this.windowManager = windowManager;
        this.battleObserver = new BattleObserver();
        this.timerTask = new Timer(500, new TimerTask());
        this.snapshot = new AtomicReference();
        this.lastRows = 0;
        this.tableModel = new BattleRankingTableModel();
        this.menu = menu;
        this.setTitle("Ranking");
    }

    protected AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void update() {
        ITurnSnapshot current = this.snapshot.get();
        if (this.lastSnapshot != current) {
            this.setResultsData();
            this.lastSnapshot = current;
            this.tableModel.updateSource(this.lastSnapshot);
            if (this.table.getModel().getRowCount() != this.lastRows) {
                this.lastRows = this.table.getModel().getRowCount();
                this.table.setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), this.table.getModel().getRowCount() * this.table.getRowHeight()));
                this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
                this.pack();
            }
            this.repaint();
        }
    }

    protected void onDialogShown() {
        this.windowManager.addBattleListener((IBattleListener)this.battleObserver);
        this.timerTask.start();
    }

    protected void onDialogHidden() {
        this.menu.getOptionsShowRankingCheckBoxMenuItem().setState(false);
        this.timerTask.stop();
        this.windowManager.removeBattleListener((IBattleListener)this.battleObserver);
        this.dispose();
    }

    private class TimerTask
    implements ActionListener {
        private TimerTask() {
        }

        public void actionPerformed(ActionEvent e) {
            RankingDialog.this.update();
        }
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            RankingDialog.this.snapshot.set(null);
        }

        public void onTurnEnded(TurnEndedEvent event) {
            RankingDialog.this.snapshot.set(event.getTurnSnapshot());
        }
    }
}

