/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.EtchedBorder;
import net.sf.robocode.ui.gfx.RobocodeLogo;
import net.sf.robocode.version.IVersionManager;

public class RcSplashScreen
extends JWindow {
    private static final Color LABEL_COLOR = Color.WHITE;
    private JLabel splashLabel;
    private JPanel splashPanel;
    private JPanel splashScreenContentPane;
    private Image splashImage;
    private final String version;
    private final transient WindowListener eventHandler = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            if (e.getSource() == RcSplashScreen.this) {
                RcSplashScreen.this.dispose();
            }
        }
    };

    public RcSplashScreen(IVersionManager versionManager) {
        this.version = versionManager.getVersion();
        this.initialize();
    }

    public JLabel getSplashLabel() {
        if (this.splashLabel == null) {
            this.splashLabel = new JLabel();
            this.splashLabel.setText("");
            this.splashLabel.setForeground(LABEL_COLOR);
            this.splashLabel.setOpaque(false);
        }
        return this.splashLabel;
    }

    private JPanel getSplashPanel() {
        if (this.splashPanel == null) {
            this.splashPanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    g.drawImage(RcSplashScreen.this.splashImage, 0, 0, null);
                    g.setColor(LABEL_COLOR);
                    g.setFont(new Font("Arial", 1, 12));
                    FontMetrics fm = g.getFontMetrics();
                    g.drawString("Version: " + RcSplashScreen.this.version, RcSplashScreen.this.splashImage.getWidth(null) - fm.stringWidth("Version: " + RcSplashScreen.this.version), RcSplashScreen.this.splashImage.getHeight(null) - 4);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(RcSplashScreen.this.splashImage.getWidth(null), RcSplashScreen.this.splashImage.getHeight(null));
                }
            };
            this.splashPanel.setLayout(new BorderLayout());
            this.splashPanel.add((Component)this.getSplashLabel(), "North");
        }
        return this.splashPanel;
    }

    private JPanel getSplashScreenContentPane() {
        if (this.splashScreenContentPane == null) {
            this.splashScreenContentPane = new JPanel();
            this.splashScreenContentPane.setBorder(new EtchedBorder());
            this.splashScreenContentPane.setLayout(new BorderLayout());
            this.splashScreenContentPane.add((Component)this.getSplashPanel(), "Center");
        }
        return this.splashScreenContentPane;
    }

    private void initialize() {
        this.splashImage = new BufferedImage(570, 213, 1);
        new RobocodeLogo().paintLogoWithTanks(this.splashImage.getGraphics());
        this.setContentPane(this.getSplashScreenContentPane());
        this.addWindowListener(this.eventHandler);
    }

    public void paint(Graphics g) {
        super.paint(g);
    }
}

