/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import net.sf.robocode.battle.BattleResultsTableModel;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.BaseScoreDialog;
import net.sf.robocode.ui.dialog.WindowUtil;
import robocode.BattleResults;

public class ResultsDialog
extends BaseScoreDialog {
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton saveButton;
    private BattleResultsTableModel tableModel;
    private final ButtonEventHandler buttonEventHandler = new ButtonEventHandler();

    public ResultsDialog(IWindowManager manager) {
        super(manager, true);
        this.initialize();
        this.addCancelByEscapeKey();
    }

    public void setup(BattleResults[] results, int numRounds) {
        this.tableModel = new BattleResultsTableModel(results, numRounds);
        this.setTitle(((BattleResultsTableModel)this.getTableModel()).getTitle());
        this.setResultsData();
        this.table.setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), this.table.getModel().getRowCount() * this.table.getRowHeight()));
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
    }

    private void saveButtonActionPerformed() {
        this.windowManager.showSaveResultsDialog(this.tableModel);
    }

    private void okButtonActionPerformed() {
        this.setVisible(false);
    }

    protected AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    protected JPanel getDialogContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.getScrollPane(), "Center");
            this.contentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.contentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.add((Component)this.getOkButton(), "East");
            this.buttonPanel.add((Component)this.getSaveButton(), "West");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this.buttonEventHandler);
            WindowUtil.setFixedSize(this.okButton, new Dimension(80, 25));
        }
        return this.okButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save");
            this.saveButton.addActionListener(this.buttonEventHandler);
            WindowUtil.setFixedSize(this.saveButton, new Dimension(80, 25));
        }
        return this.saveButton;
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ResultsDialog.this.okButtonActionPerformed();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private class ButtonEventHandler
    implements ActionListener {
        private ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ResultsDialog.this.getOkButton()) {
                ResultsDialog.this.okButtonActionPerformed();
            } else if (source == ResultsDialog.this.getSaveButton()) {
                ResultsDialog.this.saveButtonActionPerformed();
            }
        }
    }
}

