/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.ui.IRobotDialogManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.IWindowManagerExt;
import net.sf.robocode.ui.dialog.RobotDialog;
import net.sf.robocode.ui.dialog.WindowUtil;
import robocode.BattleResults;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.IBattleListener;
import robocode.control.events.TurnEndedEvent;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.IScoreSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public class RobotButton
extends JButton
implements ActionListener {
    private static final int BAR_MARGIN = 2;
    private static final int BAR_HEIGHT = 3;
    private final IWindowManagerExt windowManager;
    private final IBattleManager battleManager;
    private final BattleObserver battleObserver = new BattleObserver();
    private final IRobotDialogManager dialogManager;
    private RobotDialog robotDialog;
    private String name;
    private int robotIndex;
    private int contestIndex;
    private int maxEnergy = 1;
    private int maxScore = 1;
    private int lastEnergy;
    private int lastScore;
    private boolean isListening;

    public RobotButton(IWindowManager windowManager, IBattleManager battleManager, IRobotDialogManager dialogManager) {
        this.windowManager = (IWindowManagerExt)windowManager;
        this.battleManager = battleManager;
        this.dialogManager = dialogManager;
    }

    public void setup(String name, int maxEnergy, int robotIndex, int contestIndex, boolean attach) {
        this.name = name;
        this.robotIndex = robotIndex;
        this.contestIndex = contestIndex;
        this.lastEnergy = maxEnergy;
        this.maxEnergy = maxEnergy;
        this.initialize();
        if (attach) {
            this.attach();
            this.robotDialog.reset();
            this.battleManager.setPaintEnabled(robotIndex, this.robotDialog.isPaintEnabled());
            this.battleManager.setSGPaintEnabled(robotIndex, this.robotDialog.isSGPaintEnabled());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.robotDialog == null) {
            this.attach();
            if (!this.robotDialog.isVisible() || this.robotDialog.getState() != 0) {
                WindowUtil.packPlaceShow(this.robotDialog);
            }
        } else {
            this.robotDialog.setVisible(true);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int barMaxWidth = this.getWidth() - 4;
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        if (this.lastEnergy > 0) {
            Color color = this.lastEnergy > 50 ? Color.GREEN : (this.lastEnergy > 25 ? Color.YELLOW : Color.RED);
            g.setColor(color);
            int widthLife = Math.max(Math.min(barMaxWidth * this.lastEnergy / this.maxEnergy, barMaxWidth), 0);
            g.fillRect(2, this.getHeight() - 8, widthLife, 3);
        }
        if (this.lastScore > 0) {
            g.setColor(Color.BLUE);
            int widthScore = Math.max(Math.min(barMaxWidth * this.lastScore / this.maxScore, barMaxWidth), 0);
            g.fillRect(2, this.getHeight() - 5, widthScore, 3);
        }
    }

    private void initialize() {
        this.addActionListener(this);
        this.setPreferredSize(new Dimension(110, 25));
        this.setMinimumSize(new Dimension(110, 25));
        this.setMaximumSize(new Dimension(110, 25));
        this.setHorizontalAlignment(2);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setToolTipText(this.name);
    }

    public void attach() {
        if (!this.isListening) {
            this.isListening = true;
            this.windowManager.addBattleListener((IBattleListener)this.battleObserver);
        }
        if (this.robotDialog == null) {
            this.robotDialog = this.dialogManager.getRobotDialog(this, this.name, true);
        }
        this.robotDialog.attach(this);
    }

    public void detach() {
        if (this.isListening) {
            this.windowManager.removeBattleListener((IBattleListener)this.battleObserver);
            this.isListening = false;
        }
        if (this.robotDialog != null) {
            RobotDialog dialog = this.robotDialog;
            this.robotDialog = null;
            dialog.detach();
        }
    }

    public int getRobotIndex() {
        return this.robotIndex;
    }

    public String getRobotName() {
        return this.name;
    }

    private class BattleObserver
    extends BattleAdaptor {
        private BattleObserver() {
        }

        public void onTurnEnded(TurnEndedEvent event) {
            ITurnSnapshot turn = event.getTurnSnapshot();
            if (turn == null) {
                return;
            }
            IRobotSnapshot[] robots = turn.getRobots();
            IScoreSnapshot[] scoreSnapshotList = event.getTurnSnapshot().getIndexedTeamScores();
            RobotButton.this.maxEnergy = 0;
            for (IRobotSnapshot iRobotSnapshot : robots) {
                if (!((double)RobotButton.this.maxEnergy < iRobotSnapshot.getEnergy())) continue;
                RobotButton.this.maxEnergy = (int)iRobotSnapshot.getEnergy();
            }
            if (RobotButton.this.maxEnergy == 0) {
                RobotButton.this.maxEnergy = 1;
            }
            RobotButton.this.maxScore = 0;
            for (IRobotSnapshot iRobotSnapshot : scoreSnapshotList) {
                if (!((double)RobotButton.this.maxScore < iRobotSnapshot.getCurrentScore())) continue;
                RobotButton.this.maxScore = (int)iRobotSnapshot.getCurrentScore();
            }
            if (RobotButton.this.maxScore == 0) {
                RobotButton.this.maxScore = 1;
            }
            int newScore = (int)scoreSnapshotList[RobotButton.this.contestIndex].getCurrentScore();
            int newEnergy = (int)robots[RobotButton.this.robotIndex].getEnergy();
            boolean rep = RobotButton.this.lastEnergy != newEnergy || RobotButton.this.lastScore != newScore;
            RobotButton.this.lastEnergy = newEnergy;
            RobotButton.this.lastScore = newScore;
            if (rep) {
                RobotButton.this.repaint();
            }
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            RobotButton.this.maxScore = 0;
            for (BattleResults team : event.getIndexedResults()) {
                if (RobotButton.this.maxScore >= team.getScore()) continue;
                RobotButton.this.maxScore = team.getScore();
            }
            if (RobotButton.this.maxScore == 0) {
                RobotButton.this.maxScore = 1;
            }
            RobotButton.this.lastScore = event.getIndexedResults()[RobotButton.this.contestIndex].getScore();
            RobotButton.this.repaint();
        }

        public void onBattleFinished(BattleFinishedEvent event) {
            RobotButton.this.lastEnergy = 0;
            RobotButton.this.repaint();
        }
    }
}

