/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.gfx;

import java.awt.Color;
import robocode.util.Utils;

class ColorUtil {
    ColorUtil() {
    }

    public static Color toColor(short rgb565) {
        if (rgb565 == 0) {
            return null;
        }
        if (rgb565 == 32) {
            return Color.BLACK;
        }
        return new Color(255 * ((rgb565 & 0xF800) >> 11) / 31, 255 * ((rgb565 & 0x7E0) >> 5) / 63, 255 * (rgb565 & 0x1F) / 31);
    }

    public static short toRGB565(Color c) {
        if (c == null) {
            return 0;
        }
        short rgb = (short)((c.getRed() & 0xF8) << 8 | (c.getGreen() & 0xFC) << 3 | c.getBlue() >> 3);
        if (rgb == 0) {
            return 32;
        }
        if (rgb == 32) {
            return 64;
        }
        return rgb;
    }

    public static float[] fromRGBtoHSL(int r, int g, int b) {
        float S;
        float H;
        float R = (float)r / 255.0f;
        float G = (float)g / 255.0f;
        float B = (float)b / 255.0f;
        float min = Math.min(Math.min(R, G), B);
        float max = Math.max(Math.max(R, G), B);
        float delta = max - min;
        float L = (max + min) / 2.0f;
        if (delta == 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = L < 0.5f ? delta / (max + min) : delta / (2.0f - max - min);
            float deltaR = ((max - R) / 6.0f + delta / 2.0f) / delta;
            float deltaG = ((max - G) / 6.0f + delta / 2.0f) / delta;
            float deltaB = ((max - B) / 6.0f + delta / 2.0f) / delta;
            H = Utils.isNear((double)R, (double)max) ? deltaB - deltaG : (Utils.isNear((double)G, (double)max) ? 0.33333334f + deltaR - deltaB : 0.6666667f + deltaG - deltaR);
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        return new float[]{H, S, L};
    }

    public static int fromHSLtoRGB(float h, float s, float l) {
        float m2 = l <= 0.5f ? l * (s + 1.0f) : l + s - l * s;
        float m1 = 2.0f * l - m2;
        int r = (int)(255.0f * ColorUtil.fromHUEtoRGB(m1, m2, h + 0.33333334f));
        int g = (int)(255.0f * ColorUtil.fromHUEtoRGB(m1, m2, h));
        int b = (int)(255.0f * ColorUtil.fromHUEtoRGB(m1, m2, h - 0.33333334f));
        return (r << 8 | g) << 8 | b;
    }

    private static float fromHUEtoRGB(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return m1 + (m2 - m1) * h * 6.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2;
        }
        if (h * 3.0f < 2.0f) {
            return m1 + (m2 - m1) * (0.6666667f - h) * 6.0f;
        }
        return m1;
    }
}

