/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.battlesengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.robocode.io.Logger;
import net.sf.robocode.roborumble.util.PropertiesUtil;
import robocode.BattleResults;
import robocode.control.BattleSpecification;
import robocode.control.BattlefieldSpecification;
import robocode.control.IRobocodeEngine;
import robocode.control.RobocodeEngine;
import robocode.control.RobotResults;
import robocode.control.RobotSpecification;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.IBattleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattlesRunner {
    private final String inputfile;
    private final int numrounds;
    private final int fieldlen;
    private final int fieldhei;
    private final String outfile;
    private final String user;
    private String game;
    private static RobotResults[] lastResults;
    private static IRobocodeEngine engine;

    public BattlesRunner(String propertiesfile) {
        Properties parameters = PropertiesUtil.getProperties(propertiesfile);
        this.inputfile = parameters.getProperty("INPUT", "");
        this.numrounds = Integer.parseInt(parameters.getProperty("ROUNDS", "10"));
        this.fieldlen = Integer.parseInt(parameters.getProperty("FIELDL", "800"));
        this.fieldhei = Integer.parseInt(parameters.getProperty("FIELDH", "600"));
        this.outfile = parameters.getProperty("OUTPUT", "");
        this.user = parameters.getProperty("USER", "");
        this.game = propertiesfile;
        while (this.game.indexOf("/") != -1) {
            this.game = this.game.substring(this.game.indexOf("/") + 1);
        }
        this.game = this.game.substring(0, this.game.indexOf("."));
        this.initialize();
    }

    private void initialize() {
        if (engine == null) {
            engine = new RobocodeEngine();
            engine.addBattleListener((IBattleListener)new BattleObserver());
        }
    }

    public String getVersion() {
        return engine != null ? engine.getVersion() : null;
    }

    public void runBattlesImpl(boolean melee) {
        BattlefieldSpecification field = new BattlefieldSpecification(this.fieldlen, this.fieldhei);
        BattleSpecification battle = new BattleSpecification(this.numrounds, field, new RobotSpecification[2]);
        ArrayList<String> robots = new ArrayList<String>();
        BufferedReader br = null;
        if (this.readRobots(robots, br)) {
            return;
        }
        PrintStream outtxt = this.getRedirectedOutput();
        if (outtxt == null) {
            return;
        }
        for (int index = 0; index < robots.size(); ++index) {
            String[] param = robots.get(index).split(",");
            String enemies = this.getEnemies(melee, param);
            System.out.println("Fighting battle " + index + " ... " + enemies);
            RobotSpecification[] robotsList = engine.getLocalRepository(enemies);
            if (robotsList.length > 1) {
                String team0 = robotsList[0].getTeamId();
                String teamLast = robotsList[robotsList.length - 1].getTeamId();
                if (team0 != null && team0.equals(teamLast)) continue;
                BattleSpecification specification = new BattleSpecification(battle.getNumRounds(), battle.getBattlefield(), robotsList);
                lastResults = null;
                engine.runBattle(specification, true);
                if (lastResults == null || lastResults.length <= 1) continue;
                this.dumpResults(outtxt, lastResults, param[param.length - 1], melee);
                continue;
            }
            System.err.println("Skipping battle because can't load robots: " + enemies);
        }
        outtxt.close();
    }

    private String getEnemies(boolean melee, String[] param) {
        String enemies;
        if (melee) {
            StringBuilder eb = new StringBuilder();
            for (int i = 0; i < param.length - 1; ++i) {
                if (i > 0) {
                    eb.append(',');
                }
                eb.append(param[i]);
            }
            enemies = eb.toString();
        } else {
            enemies = param[0] + "," + param[1];
        }
        return enemies;
    }

    private PrintStream getRedirectedOutput() {
        try {
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outfile, true)), true);
        }
        catch (IOException e) {
            System.out.println("Not able to open output file ... Aborting");
            System.out.println(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readRobots(ArrayList<String> robots, BufferedReader br) {
        try {
            String record;
            FileReader fr = new FileReader(this.inputfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                robots.add(record);
            }
        }
        catch (IOException e) {
            System.out.println("Battles input file not found ... Aborting");
            System.out.println(e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private void dumpResults(PrintStream outtxt, RobotResults[] results, String last, boolean melee) {
        String BOT_INDEX_PATTERN = "\\[.*\\]";
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results.length; ++j) {
                if (i >= j) continue;
                RobotSpecification bot1 = results[i].getRobot();
                RobotSpecification bot2 = results[j].getRobot();
                String name1 = bot1.getTeamId() != null ? bot1.getTeamId().replaceAll("\\[.*\\]", "") : bot1.getNameAndVersion();
                String name2 = bot2.getTeamId() != null ? bot2.getTeamId().replaceAll("\\[.*\\]", "") : bot2.getNameAndVersion();
                int points1 = results[i].getScore();
                int points2 = results[j].getScore();
                int bullets1 = results[i].getBulletDamage();
                int bullets2 = results[j].getBulletDamage();
                int survival1 = results[i].getFirsts();
                int survival2 = results[j].getFirsts();
                outtxt.println(this.game + "," + this.numrounds + "," + this.fieldlen + "x" + this.fieldhei + "," + this.user + "," + System.currentTimeMillis() + "," + last);
                outtxt.println(name1 + "," + points1 + "," + bullets1 + "," + survival1);
                outtxt.println(name2 + "," + points2 + "," + bullets2 + "," + survival2);
            }
        }
        if (melee) {
            System.out.println("RESULT = " + results[0].getRobot().getNameAndVersion() + " wins, " + results[1].getRobot().getNameAndVersion() + " is second.");
        } else {
            RobotSpecification winnerBot = results[0].getRobot();
            String winnerBotName = winnerBot.getTeamId() != null ? winnerBot.getTeamId().replaceAll("\\[.*\\]", "") : winnerBot.getNameAndVersion();
            System.out.println("RESULT = " + winnerBotName + " wins " + results[0].getScore() + " to " + results[1].getScore());
        }
    }

    static /* synthetic */ RobotResults[] access$002(RobotResults[] x0) {
        lastResults = x0;
        return x0;
    }

    class BattleObserver
    extends BattleAdaptor {
        BattleObserver() {
        }

        public void onBattleError(BattleErrorEvent event) {
            Logger.realErr.println(event.getError());
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            BattlesRunner.access$002(RobotResults.convertResults((BattleResults[])event.getSortedResults()));
        }
    }
}

