/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.netengine;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class FileTransfer {
    private static final int CONNECTION_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSessionId(String url) {
        Object object;
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(url).openConnection();
            if (con == null) {
                throw new IOException("Could not open connection to '" + url + "'");
            }
            GetSessionIdThread sessionIdThread = new GetSessionIdThread(con);
            sessionIdThread.start();
            object = sessionIdThread.monitor;
            synchronized (object) {
                while (!sessionIdThread.isFinished) {
                    try {
                        sessionIdThread.monitor.wait(5000L);
                        sessionIdThread.interrupt();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        String string = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 11] lbl18 : MonitorExitStatement: MONITOREXIT : var3_4
                        if (con == null) return string;
                        con.disconnect();
                        return string;
                    }
                }
            }
            object = sessionIdThread.sessionId;
            return object;
        }
        catch (IOException e) {
            object = null;
            return object;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DownloadStatus download(String url, String filename, String sessionId) {
        Object object;
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(url).openConnection();
            if (con == null) {
                throw new IOException("Could not open connection to '" + url + "'");
            }
            if (sessionId != null) {
                con.setRequestProperty("Cookie", sessionId);
            }
            con.setDoInput(true);
            con.setDoOutput(false);
            con.setUseCaches(false);
            con.setConnectTimeout(5000);
            con.connect();
            DownloadThread downloadThread = new DownloadThread(con, filename);
            downloadThread.start();
            object = downloadThread.monitor;
            synchronized (object) {
                while (!downloadThread.isFinished) {
                    try {
                        downloadThread.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        DownloadStatus downloadStatus = DownloadStatus.COULD_NOT_CONNECT;
                        // MONITOREXIT @DISABLED, blocks:[0, 19, 10, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var5_6 /* !! */ 
                        try {
                            if (con == null) return downloadStatus;
                            con.disconnect();
                            return downloadStatus;
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        return downloadStatus;
                    }
                }
            }
            object = downloadThread.status;
            return object;
        }
        catch (IOException e) {
            object = DownloadStatus.COULD_NOT_CONNECT;
            return object;
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Throwable ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(String src_file, String dest_file) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            if (src_file.equals(dest_file)) {
                throw new IOException("You cannot copy a file onto itself");
            }
            byte[] buf = new byte[4096];
            in = new FileInputStream(src_file);
            out = new FileOutputStream(dest_file);
            while (in.available() > 0) {
                out.write(buf, 0, in.read(buf, 0, buf.length));
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    static final class ReadInputStreamToBufferThread
    extends WorkerThread {
        int bytesRead;
        final InputStream in;
        final byte[] buf;

        ReadInputStreamToBufferThread(InputStream in, byte[] buf) {
            super("FileTransfer: Read input stream to buffer");
            this.in = in;
            this.buf = buf;
        }

        public void run() {
            try {
                this.bytesRead = this.in.read(this.buf);
            }
            catch (Exception e) {
                this.bytesRead = -1;
            }
            this.notifyFinish();
        }
    }

    static final class GetContentLengthThread
    extends WorkerThread {
        int contentLength;
        final HttpURLConnection con;

        GetContentLengthThread(HttpURLConnection con) {
            super("FileTransfer: Get content length");
            this.con = con;
        }

        public void run() {
            try {
                this.contentLength = this.con.getContentLength();
            }
            catch (Exception e) {
                this.contentLength = -1;
            }
            this.notifyFinish();
        }
    }

    static final class GetResponseCodeThread
    extends WorkerThread {
        int responseCode;
        final HttpURLConnection con;

        GetResponseCodeThread(HttpURLConnection con) {
            super("FileTransfer: Get response code");
            this.con = con;
        }

        public void run() {
            try {
                this.responseCode = this.con.getResponseCode();
            }
            catch (Exception e) {
                this.responseCode = -1;
            }
            this.notifyFinish();
        }
    }

    private static final class DownloadThread
    extends WorkerThread {
        DownloadStatus status = DownloadStatus.COULD_NOT_CONNECT;
        final HttpURLConnection con;
        final String filename;
        InputStream in;
        OutputStream out;

        DownloadThread(HttpURLConnection con, String filename) {
            super("FileTransfer: Download");
            this.con = con;
            this.filename = filename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                int bytesRead;
                GetResponseCodeThread responseThread = new GetResponseCodeThread(this.con);
                responseThread.start();
                Object object = responseThread.monitor;
                synchronized (object) {
                    while (!responseThread.isFinished) {
                        try {
                            responseThread.monitor.wait(5000L);
                            responseThread.interrupt();
                        }
                        catch (InterruptedException e) {
                            this.notifyFinish();
                            // MONITOREXIT @DISABLED, blocks:[0, 67, 38, 41] lbl13 : MonitorExitStatement: MONITOREXIT : var2_8
                            if (this.in != null) {
                                try {
                                    this.in.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            if (this.out == null) return;
                            try {
                                this.out.close();
                                return;
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                            return;
                        }
                    }
                }
                int responseCode = responseThread.responseCode;
                if (responseCode == -1) {
                    this.notifyFinish();
                    return;
                }
                if (responseCode == 404) {
                    this.status = DownloadStatus.FILE_NOT_FOUND;
                    this.notifyFinish();
                    return;
                }
                if (responseCode != 200) {
                    this.notifyFinish();
                    return;
                }
                GetContentLengthThread contentLengthThread = new GetContentLengthThread(this.con);
                contentLengthThread.start();
                Object e3 = contentLengthThread.monitor;
                synchronized (e3) {
                    while (!contentLengthThread.isFinished) {
                        try {
                            contentLengthThread.monitor.wait(5000L);
                            contentLengthThread.interrupt();
                        }
                        catch (InterruptedException e) {
                            this.notifyFinish();
                            // MONITOREXIT @DISABLED, blocks:[0, 50, 68, 39] lbl50 : MonitorExitStatement: MONITOREXIT : e
                            if (this.in != null) {
                                try {
                                    this.in.close();
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                            }
                            if (this.out == null) return;
                            try {
                                this.out.close();
                                return;
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                            return;
                        }
                    }
                }
                int size = contentLengthThread.contentLength;
                if (size == -1) {
                    this.notifyFinish();
                    return;
                }
                this.in = this.con.getInputStream();
                this.out = new FileOutputStream(this.filename);
                byte[] buf = new byte[4096];
                for (int totalRead = 0; totalRead < size; totalRead += bytesRead) {
                    ReadInputStreamToBufferThread readThread = new ReadInputStreamToBufferThread(this.in, buf);
                    readThread.start();
                    Object object2 = readThread.monitor;
                    synchronized (object2) {
                        while (!readThread.isFinished) {
                            try {
                                readThread.monitor.wait(5000L);
                                readThread.interrupt();
                            }
                            catch (InterruptedException e) {
                                this.notifyFinish();
                                // MONITOREXIT @DISABLED, blocks:[0, 69, 70, 55, 40] lbl84 : MonitorExitStatement: MONITOREXIT : var9_31
                                if (this.in != null) {
                                    try {
                                        this.in.close();
                                    }
                                    catch (IOException e6) {
                                        e6.printStackTrace();
                                    }
                                }
                                if (this.out == null) return;
                                try {
                                    this.out.close();
                                    return;
                                }
                                catch (IOException e7) {
                                    e7.printStackTrace();
                                }
                                return;
                            }
                        }
                    }
                    bytesRead = readThread.bytesRead;
                    if (bytesRead == -1) {
                        this.notifyFinish();
                        break;
                    }
                    this.out.write(buf, 0, bytesRead);
                }
                this.status = DownloadStatus.OK;
                this.notifyFinish();
                return;
            }
            catch (IOException e) {
                this.status = DownloadStatus.COULD_NOT_CONNECT;
                return;
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static final class GetSessionIdThread
    extends WorkerThread {
        String sessionId;
        final HttpURLConnection con;

        GetSessionIdThread(HttpURLConnection con) {
            super("FileTransfer: Get session ID");
            this.con = con;
        }

        public void run() {
            try {
                String cookieVal = this.con.getHeaderField("Set-Cookie");
                if (cookieVal != null) {
                    this.sessionId = cookieVal.substring(0, cookieVal.indexOf(";"));
                }
            }
            catch (Exception e) {
                this.sessionId = null;
            }
            this.notifyFinish();
        }
    }

    private static class WorkerThread
    extends Thread {
        final Object monitor = new Object();
        volatile boolean isFinished;

        public WorkerThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyFinish() {
            Object object = this.monitor;
            synchronized (object) {
                this.isFinished = true;
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadStatus {
        OK,
        COULD_NOT_CONNECT,
        FILE_NOT_FOUND;

    }
}

