/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.netengine;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import net.sf.robocode.roborumble.util.PropertiesUtil;

public class UpdateRatingFiles {
    private String game;
    private final String minibots;
    private final String microbots;
    private final String nanobots;
    private final String battlesnumfile;
    private final String generalratings;
    private final String miniratings;
    private final String microratings;
    private final String nanoratings;

    public UpdateRatingFiles(String propertiesfile) {
        Properties parameters = PropertiesUtil.getProperties(propertiesfile);
        this.game = propertiesfile;
        while (this.game.indexOf("/") != -1) {
            this.game = this.game.substring(this.game.indexOf("/") + 1);
        }
        this.game = this.game.substring(0, this.game.indexOf("."));
        this.minibots = parameters.getProperty("MINIBOTS", "");
        this.microbots = parameters.getProperty("MICROBOTS", "");
        this.nanobots = parameters.getProperty("NANOBOTS", "");
        this.battlesnumfile = parameters.getProperty("BATTLESNUMFILE", "");
        this.generalratings = parameters.getProperty("RATINGS.GENERAL", "");
        this.miniratings = parameters.getProperty("RATINGS.MINIBOTS", "");
        this.microratings = parameters.getProperty("RATINGS.MICROBOTS", "");
        this.nanoratings = parameters.getProperty("RATINGS.NANOBOTS", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRatings() {
        Vector<String> battles = new Vector<String>();
        BufferedReader br = null;
        try {
            String record;
            FileReader fr = new FileReader(this.battlesnumfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                battles.add(record);
            }
        }
        catch (IOException e) {
            System.out.println("Can't open # battles file ... Aborting # battles update");
            boolean record = false;
            return record;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        Properties all = PropertiesUtil.getProperties(this.generalratings);
        Properties mini = PropertiesUtil.getProperties(this.miniratings);
        Properties micro = PropertiesUtil.getProperties(this.microratings);
        Properties nano = PropertiesUtil.getProperties(this.nanoratings);
        for (String battle : battles) {
            String[] battleSpec = battle.split(",");
            battleSpec[1] = battleSpec[1].replaceAll(" ", "_");
            double num = Double.parseDouble(battleSpec[2]);
            if (battleSpec[0].equals(this.game)) {
                this.updateRecord(battleSpec[1], num, all);
                continue;
            }
            if (battleSpec[0].equals(this.minibots) && mini != null) {
                this.updateRecord(battleSpec[1], num, mini);
                continue;
            }
            if (battleSpec[0].equals(this.microbots) && micro != null) {
                this.updateRecord(battleSpec[1], num, micro);
                continue;
            }
            if (!battleSpec[0].equals(this.nanobots) || nano == null) continue;
            this.updateRecord(battleSpec[1], num, nano);
        }
        return PropertiesUtil.storeProperties(all, this.generalratings, "General ratings updated with new battles number") && PropertiesUtil.storeProperties(all, this.miniratings, "Mini ratings updated with new battles number") && PropertiesUtil.storeProperties(all, this.microratings, "Micro ratings updated with new battles number") && PropertiesUtil.storeProperties(all, this.nanoratings, "Nano ratings updated with new battles number");
    }

    private void updateRecord(String bot, double battles, Properties ratings) {
        String values = ratings.getProperty(bot);
        if (values == null) {
            return;
        }
        String[] value = values.split(",");
        values = value[0] + "," + Double.toString(battles) + "," + value[2];
        ratings.setProperty(bot, values);
    }
}

