/*
 * Decompiled with CFR 0.152.
 */
package roborumble;

import java.util.Properties;
import net.sf.robocode.roborumble.battlesengine.BattlesRunner;
import net.sf.robocode.roborumble.battlesengine.PrepareBattles;
import net.sf.robocode.roborumble.netengine.BotsDownload;
import net.sf.robocode.roborumble.netengine.ResultsUpload;
import net.sf.robocode.roborumble.netengine.UpdateRatingFiles;
import net.sf.robocode.roborumble.util.PropertiesUtil;

public class RoboRumbleAtHome {
    public static void main(String[] args) {
        String parameters = "./roborumble/roborumble.txt";
        try {
            parameters = args[0];
        }
        catch (Exception e) {
            System.out.println("No argument found specifying properties file. \"roborumble.txt\" assumed.");
        }
        Properties param = PropertiesUtil.getProperties(parameters);
        String downloads = param.getProperty("DOWNLOAD", "NOT");
        String executes = param.getProperty("EXECUTE", "NOT");
        String uploads = param.getProperty("UPLOAD", "NOT");
        String iterates = param.getProperty("ITERATE", "NOT");
        String runonly = param.getProperty("RUNONLY", "GENERAL");
        String melee = param.getProperty("MELEE", "NOT");
        int iterations = 0;
        long lastdownload = 0L;
        boolean ratingsdownloaded = false;
        String version = null;
        do {
            BattlesRunner engine = new BattlesRunner(parameters);
            if (version == null) {
                version = engine.getVersion();
            }
            System.out.println("Iteration number " + iterations);
            if (downloads.equals("YES")) {
                BotsDownload download = new BotsDownload(parameters);
                if (runonly.equals("SERVER")) {
                    System.out.println("Downloading rating files ...");
                    ratingsdownloaded = download.downloadRatings();
                }
                if (System.currentTimeMillis() - lastdownload > 0x6DDD00L) {
                    System.out.println("Downloading participants list ...");
                    boolean participantsdownloaded = download.downloadParticipantsList();
                    System.out.println("Downloading missing bots ...");
                    download.downloadMissingBots();
                    download.updateCodeSize();
                    if (ratingsdownloaded && participantsdownloaded) {
                        System.out.println("Removing old participants from server ...");
                        download.notifyServerForOldParticipants();
                    }
                    lastdownload = System.currentTimeMillis();
                }
            }
            if (executes.equals("YES")) {
                boolean ready;
                boolean isMelee = melee.equals("YES");
                PrepareBattles battles = new PrepareBattles(parameters);
                if (isMelee) {
                    System.out.println("Preparing melee battles list ...");
                    ready = battles.createMeleeBattlesList();
                } else {
                    boolean isSmartBattles;
                    boolean bl = isSmartBattles = ratingsdownloaded && runonly.equals("SERVER");
                    if (isSmartBattles) {
                        System.out.print("Preparing battles list using smart battles...");
                        ready = battles.createSmartBattlesList();
                    } else {
                        System.out.print("Preparing battles list...");
                        ready = battles.createBattlesList();
                    }
                }
                System.setProperty("PARALLEL", "false");
                System.setProperty("RANDOMSEED", "none");
                if (ready) {
                    if (isMelee) {
                        System.out.println("Executing melee battles ...");
                    } else {
                        System.out.println("Executing battles ...");
                    }
                    engine.runBattlesImpl(isMelee);
                }
            }
            if (uploads.equals("YES") && version != null) {
                System.out.println("Uploading results ...");
                ResultsUpload upload = new ResultsUpload(parameters, version);
                upload.uploadResults();
                System.out.println("Updating number of battles fought ...");
                UpdateRatingFiles updater = new UpdateRatingFiles(parameters);
                ratingsdownloaded = updater.updateRatings();
            }
            ++iterations;
        } while (iterates.equals("YES"));
    }
}

