/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.jdbc.ExecutionResult;
import org.neo4j.jdbc.QueryExecutor;
import org.neo4j.jdbc.Version;
import org.neo4j.jdbc.rest.JsonUtils;
import org.neo4j.jdbc.rest.Resources;
import org.neo4j.jdbc.rest.ResultParser;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Filter;

public class RestQueryExecutor
implements QueryExecutor {
    protected static final Log log = LogFactory.getLog(RestQueryExecutor.class);
    private ClientResource cypherResource;
    private ObjectMapper mapper = new ObjectMapper();
    private Version version;
    private final Resources.DiscoveryClientResource discovery;

    public RestQueryExecutor(Resources resources) throws SQLException {
        try {
            this.discovery = resources.getDiscoveryResource();
            this.version = new Version(this.discovery.getVersion());
            String cypherPath = this.discovery.getCypherPath();
            this.cypherResource = resources.getCypherResource(cypherPath);
        }
        catch (IOException e) {
            throw new SQLNonTransientConnectionException(e);
        }
    }

    @Override
    public ExecutionResult executeQuery(String query, Map<String, Object> parameters, boolean autoCommit) throws Exception {
        if (!autoCommit) {
            throw new SQLException("Manual commit mode not supported over REST");
        }
        ClientResource resource = null;
        try {
            ObjectNode queryNode = this.queryParameter(query, parameters);
            resource = new ClientResource(this.cypherResource);
            Representation rep = resource.post((Object)queryNode.toString());
            rep.setCharacterSet(new CharacterSet("UTF-8"));
            JsonNode node = this.mapper.readTree(rep.getReader());
            ResultParser parser = new ResultParser(node);
            return new ExecutionResult(parser.getColumns(), parser.streamData());
        }
        catch (ResourceException e) {
            String msg = this.extractErrorMessage(resource);
            if (msg != null) {
                throw new SQLException(msg, e);
            }
            throw new SQLException(e.getStatus().getReasonPhrase(), e);
        }
        catch (JsonProcessingException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private String extractErrorMessage(ClientResource resource) {
        try {
            if (resource == null) {
                return null;
            }
            Response resp = resource.getResponse();
            if (resp == null) {
                return null;
            }
            Representation rep = resp.getEntity();
            rep.setCharacterSet(new CharacterSet("UTF-8"));
            JsonNode node = this.mapper.readTree(rep.getReader());
            if (node == null) {
                return null;
            }
            JsonNode msg = node.findValue("message");
            if (msg == null) {
                return null;
            }
            return msg.getTextValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void stop() throws Exception {
        ((Filter)this.cypherResource.getNext()).stop();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    private ObjectNode queryParameter(String query, Map<String, Object> parameters) {
        ObjectNode queryNode = this.mapper.createObjectNode();
        queryNode.put("query", this.escapeQuery(query));
        if (parameters != null) {
            queryNode.put("params", (JsonNode)JsonUtils.serialize(parameters, this.mapper));
        }
        return queryNode;
    }

    private String escapeQuery(String query) {
        query = query.replace('\"', '\'');
        query = query.replace('\n', ' ');
        return query;
    }

    @Override
    public void commit() throws Exception {
    }

    @Override
    public void rollback() throws Exception {
    }
}

