/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.math.BigDecimal;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class JsonUtils {
    static ObjectNode serialize(Map<String, Object> parameters, ObjectMapper mapper) {
        ObjectNode params = mapper.createObjectNode();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                params.putNull(name);
                continue;
            }
            if (value instanceof String) {
                params.put(name, value.toString());
                continue;
            }
            if (value instanceof Integer) {
                params.put(name, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                params.put(name, (Long)value);
                continue;
            }
            if (value instanceof Boolean) {
                params.put(name, (Boolean)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                params.put(name, (BigDecimal)value);
                continue;
            }
            if (value instanceof Double) {
                params.put(name, (Double)value);
                continue;
            }
            if (value instanceof byte[]) {
                params.put(name, (byte[])value);
                continue;
            }
            if (value instanceof Float) {
                params.put(name, (Float)value);
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                if ((double)number.longValue() == number.doubleValue()) {
                    params.put(name, number.longValue());
                    continue;
                }
                params.put(name, number.doubleValue());
                continue;
            }
            if (value instanceof Map) {
                params.put(name, (JsonNode)JsonUtils.serialize((Map)value, mapper));
                continue;
            }
            if (value instanceof Iterable) {
                params.put(name, (JsonNode)JsonUtils.serialize((Iterable)value, mapper));
                continue;
            }
            throw new IllegalArgumentException("Could not serialize value " + entry.getKey() + " " + entry.getValue());
        }
        return params;
    }

    static ArrayNode serialize(Iterable<Object> iterable, ObjectMapper mapper) {
        ArrayNode array = mapper.createArrayNode();
        for (Object value : iterable) {
            if (value == null) {
                array.addNull();
                continue;
            }
            if (value instanceof String) {
                array.add(value.toString());
                continue;
            }
            if (value instanceof Integer) {
                array.add((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                array.add((Long)value);
                continue;
            }
            if (value instanceof Boolean) {
                array.add((Boolean)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                array.add((BigDecimal)value);
                continue;
            }
            if (value instanceof Double) {
                array.add((Double)value);
                continue;
            }
            if (value instanceof byte[]) {
                array.add((byte[])value);
                continue;
            }
            if (value instanceof Float) {
                array.add((Float)value);
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                if ((double)number.longValue() == number.doubleValue()) {
                    array.add(number.longValue());
                    continue;
                }
                array.add(number.doubleValue());
                continue;
            }
            if (value instanceof Map) {
                array.add((JsonNode)JsonUtils.serialize((Map)value, mapper));
                continue;
            }
            if (value instanceof Iterable) {
                array.add((JsonNode)JsonUtils.serialize((Iterable)value, mapper));
                continue;
            }
            throw new IllegalArgumentException("Could not serialize value " + value);
        }
        return array;
    }
}

