/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.fasttcp.exceptions.ListenerNotDefinedException;
import org.fasttcp.io.SocketInputStream;
import org.fasttcp.io.SocketOutputStream;
import org.fasttcp.net.TransferPackage;
import org.fasttcp.net.interfaces.ClientListener;
import org.fasttcp.net.interfaces.Connectable;

public class Client
extends Thread
implements Connectable {
    private final Socket socket;
    private final SocketOutputStream outputStream;
    private final SocketInputStream inputStream;
    private ClientListener clientListener;
    private boolean connected;
    private long serverId;

    public Client(String host, int port) throws IOException {
        this(new Socket(host, port));
    }

    public Client(InetAddress address, int port) throws IOException {
        this(new Socket(address, port));
    }

    public Client(Socket socket) throws IOException {
        this(socket, new SocketOutputStream(socket.getOutputStream()), new SocketInputStream(socket.getInputStream()));
    }

    public Client(Socket socket, SocketOutputStream outputStream, SocketInputStream inputStream) {
        this.socket = socket;
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.serverId = Integer.MIN_VALUE;
    }

    Client(Socket socket, long serverId) throws IOException {
        this(socket, new SocketOutputStream(socket.getOutputStream()), new SocketInputStream(socket.getInputStream()), serverId);
    }

    Client(Socket socket, SocketOutputStream outputStream, SocketInputStream inputStream, long serverId) {
        this.socket = socket;
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.serverId = serverId;
    }

    private void sendPackage(TransferPackage pkg) throws IOException {
        this.outputStream.writePackage(pkg);
    }

    private TransferPackage recvPkg() throws IOException, ClassNotFoundException {
        return this.inputStream.readPackage();
    }

    private void closeAll() throws IOException {
        this.outputStream.close();
        this.inputStream.close();
        this.socket.close();
    }

    public void setListener(ClientListener listener) {
        this.clientListener = listener;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public SocketOutputStream getOutputStream() {
        return this.outputStream;
    }

    public SocketInputStream getInputStream() {
        return this.inputStream;
    }

    public ClientListener getClientListener() {
        return this.clientListener;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    void unlink() throws IOException {
        this.closeAll();
    }

    @Override
    public void connect() throws IOException {
        this.sendPackage(new TransferPackage("con", null));
        this.connected = true;
    }

    @Override
    public void disconnect() throws IOException {
        this.sendPackage(new TransferPackage("dis", null));
        this.connected = false;
    }

    @Override
    public void send(byte[] data) throws IOException {
        this.sendPackage(new TransferPackage("bytes", data));
    }

    @Override
    public void send(byte[] data, int offset, int lenght) throws IOException {
        byte[] newBuff = new byte[lenght];
        System.arraycopy(data, offset, newBuff, 0, lenght);
        this.sendPackage(new TransferPackage("bytes", newBuff));
    }

    @Override
    public void send(String data) throws IOException {
        this.sendPackage(new TransferPackage("str", data));
    }

    @Override
    public void send(Object data) throws IOException {
        this.sendPackage(new TransferPackage("obj", data));
    }

    @Override
    public void send(char data) throws IOException {
        this.send((byte)data);
    }

    @Override
    public void send(byte data) throws IOException {
        this.sendPackage(new TransferPackage("byte", data));
    }

    @Override
    public void send(short data) throws IOException {
        this.sendPackage(new TransferPackage("sh", data));
    }

    @Override
    public void send(int data) throws IOException {
        this.sendPackage(new TransferPackage("int", data));
    }

    @Override
    public void send(long data) throws IOException {
        this.sendPackage(new TransferPackage("l", data));
    }

    @Override
    public void send(float data) throws IOException {
        this.sendPackage(new TransferPackage("f", Float.valueOf(data)));
    }

    @Override
    public void send(double data) throws IOException {
        this.sendPackage(new TransferPackage("d", data));
    }

    @Override
    public byte[] recvBuffer() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(byte[].class);
    }

    @Override
    public String recvStr() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(String.class);
    }

    @Override
    public Object recvObject() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getData();
    }

    @Override
    public char recvChar() throws IOException, ClassNotFoundException {
        return (char)this.recvByte();
    }

    @Override
    public byte recvByte() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Byte.TYPE);
    }

    @Override
    public short recvShort() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Short.TYPE);
    }

    @Override
    public int recvInt() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Integer.TYPE);
    }

    @Override
    public long recvLong() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Long.TYPE);
    }

    @Override
    public float recvFloat() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Float.TYPE).floatValue();
    }

    @Override
    public double recvDouble() throws IOException, ClassNotFoundException {
        return this.recvPkg().getData().getParsedData(Double.TYPE);
    }

    @Override
    public void run() {
        if (this.clientListener == null) {
            throw new ListenerNotDefinedException();
        }
        this.connected = true;
        while (this.connected) {
            try {
                if (this.inputStream.available() > 0) {
                    this.clientListener.onRequest(this);
                }
                Thread.sleep(1L);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

