/*
 * Decompiled with CFR 0.152.
 */
package org.fasttcp.test;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;
import org.fasttcp.io.SocketInputStream;
import org.fasttcp.io.SocketOutputStream;
import org.fasttcp.net.Client;
import org.fasttcp.net.Server;
import org.fasttcp.net.TransferPackage;
import org.fasttcp.net.interfaces.ServerListener;
import org.fasttcp.sys.Log;

public class Main {
    private static final int megabyte = 0x100000;

    public static void main(String[] args) throws Exception {
        Server server = new Server();
        server.bind(4000);
        server.setServerListener(new ServerListener(){

            @Override
            public void onClientConnected(Socket socket) throws IOException, ClassNotFoundException {
                System.out.println("Cliente conectado: " + socket.getInetAddress().getHostAddress());
            }

            @Override
            public void onClientDisconnected(long clientId) {
            }
        });
        server.setClientListener(client -> {
            try {
                Log.d(client.recvStr());
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        server.start();
        Client client2 = new Client("localhost", 4000);
        client2.setListener(cli -> {
            try {
                Log.d(cli.recvStr());
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        client2.connect();
        client2.start();
        client2.send("Hello Server!");
        Scanner scan = new Scanner(System.in);
        while (true) {
            System.out.print("Msg: ");
            client2.send(scan.nextLine());
        }
    }

    private static void execStreamTest() throws IOException, ClassNotFoundException {
        ServerSocket serverSock = new ServerSocket(4000);
        Socket client = new Socket("localhost", 4000);
        Socket accept = serverSock.accept();
        TransferPackage pkg = new TransferPackage("byte", 4);
        SocketOutputStream out = new SocketOutputStream(client.getOutputStream());
        SocketInputStream in = new SocketInputStream(accept.getInputStream());
        System.out.println("Pkg: " + pkg.toSerialString());
        out.writePackage(pkg);
        pkg = in.readPackage();
        System.out.println("PKg Recv: " + pkg.toSerialString());
        System.exit(0);
    }

    public static String createString(int lenght) {
        StringBuilder sbStr = new StringBuilder();
        for (int i = 0; i < lenght / 100; ++i) {
            sbStr.append("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        }
        return sbStr.toString();
    }

    public static void isEquals(String a, String b) {
        boolean isEquals;
        char[] cb;
        char[] ca = a.toCharArray();
        if (ca.length != (cb = b.toCharArray()).length) {
            isEquals = false;
        } else {
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == cb[i]) continue;
                isEquals = false;
                break;
            }
        }
        isEquals = true;
        System.out.println(isEquals ? "Son Iguales" : "Son Distintos");
    }
}

