/*
 * Decompiled with CFR 0.152.
 */
package org.netutils.async;

import java.io.IOException;
import org.netutils.async.AsyncAction;
import org.netutils.async.AsyncThenAction;

public class AsyncTask<R> {
    private volatile AsyncAction<R> action;
    private volatile R result;
    private volatile Thread executor;
    private volatile Thread tResults;

    public AsyncTask() {
    }

    public AsyncTask(AsyncAction<R> action) {
        this.action = action;
    }

    public boolean isDone() {
        return !this.executor.isAlive();
    }

    public AsyncTask<R> execute() {
        this.executor = new Thread(() -> {
            try {
                this.result = this.action.call();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.executor.start();
        return this;
    }

    public AsyncTask<R> execute(AsyncAction<R> action) {
        this.action = action;
        return this.execute();
    }

    public AsyncTask<R> then(AsyncThenAction<R> action) {
        while (this.executor == null || this.executor.isAlive()) {
        }
        this.tResults = new Thread(() -> action.then(this.result));
        this.tResults.start();
        return this;
    }

    public R get() {
        return this.result;
    }
}

