/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Buffer;
import org.jgroups.util.Headers;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Streamable {
    protected Address dest_addr;
    protected Address src_addr;
    protected byte[] buf;
    protected int offset;
    protected int length;
    protected Headers headers;
    protected volatile short flags;
    protected volatile byte transient_flags;
    protected static final Log log = LogFactory.getLog(Message.class);
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    public static final Flag OOB = Flag.OOB;
    public static final Flag DONT_BUNDLE = Flag.DONT_BUNDLE;
    public static final Flag NO_FC = Flag.NO_FC;
    public static final Flag SCOPED = Flag.SCOPED;
    public static final Flag NO_RELIABILITY = Flag.NO_RELIABILITY;
    public static final Flag NO_TOTAL_ORDER = Flag.NO_TOTAL_ORDER;
    public static final Flag NO_RELAY = Flag.NO_RELAY;
    public static final Flag RSVP = Flag.RSVP;
    public static final TransientFlag OOB_DELIVERED = TransientFlag.OOB_DELIVERED;

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(3);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf);
    }

    public Message(Address dest, byte[] buf) {
        this(dest, (Address)null, buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, byte[] buf, int offset, int length) {
        this(dest, null, buf, offset, length);
    }

    public Message(Address dest, Address src, Object obj) {
        this(dest);
        this.setSrc(src);
        this.setObject(obj);
    }

    public Message(Address dest, Object obj) {
        this(dest, null, obj);
    }

    public Message() {
        this.headers = Message.createHeaders(3);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(3);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public Address dest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Message dest(Address new_dest) {
        this.dest_addr = new_dest;
        return this;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public Address src() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public Message src(Address new_src) {
        this.src_addr = new_src;
        return this;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final Message setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public final Message setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public final Message setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map<Short, Header> getHeaders() {
        return this.headers.getHeaders();
    }

    public String printHeaders() {
        return this.headers.printHeaders();
    }

    public int getNumHeaders() {
        return this.headers != null ? this.headers.size() : 0;
    }

    public final Message setObject(Object obj) {
        if (obj == null) {
            return this;
        }
        if (obj instanceof byte[]) {
            return this.setBuffer((byte[])obj);
        }
        if (obj instanceof Buffer) {
            return this.setBuffer((Buffer)obj);
        }
        try {
            return this.setBuffer(Util.objectToByteBuffer(obj));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public final Object getObject() {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Message setFlag(Flag ... flags) {
        if (flags != null) {
            for (Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags | flag.value());
            }
        }
        return this;
    }

    public Message setFlag(short flag) {
        this.flags = (short)(this.flags | flag);
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public Message clearFlag(Flag ... flags) {
        if (flags != null) {
            for (Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags & ~flag.value());
            }
        }
        return this;
    }

    public static boolean isFlagSet(short flags, Flag flag) {
        return flag != null && (flags & flag.value()) == flag.value();
    }

    public boolean isFlagSet(Flag flag) {
        return Message.isFlagSet(this.flags, flag);
    }

    public Message setTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (byte)(this.transient_flags | flag.value());
            }
        }
        return this;
    }

    public synchronized boolean setTransientFlagIfAbsent(TransientFlag flag) {
        if (this.isTransientFlagSet(flag)) {
            return false;
        }
        this.setTransientFlag(flag);
        return true;
    }

    public Message clearTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (byte)(this.transient_flags & ~flag.value());
            }
        }
        return this;
    }

    public boolean isTransientFlagSet(TransientFlag flag) {
        return flag != null && (this.transient_flags & flag.value()) == flag.value();
    }

    public short getTransientFlags() {
        return this.transient_flags;
    }

    public Message setScope(short scope) {
        Util.setScope(this, scope);
        return this;
    }

    public short getScope() {
        return Util.getScope(this);
    }

    public Message putHeader(short id, Header hdr) {
        if (id < 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        this.headers.putHeader(id, hdr);
        return this;
    }

    public Header putHeaderIfAbsent(short id, Header hdr) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        return this.headers.putHeaderIfAbsent(id, hdr);
    }

    public Header getHeader(short id) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid. Add the protocol which calls " + "getHeader() to jg-protocol-ids.xml");
        }
        return this.headers.getHeader(id);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        return this.copy(copy_buffer, true);
    }

    public Message copy(boolean copy_buffer, boolean copy_headers) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        retval.flags = this.flags;
        retval.transient_flags = this.transient_flags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = copy_headers ? Message.createHeaders(this.headers) : Message.createHeaders(3);
        return retval;
    }

    public Message copy(boolean copy_buffer, short starting_id) {
        return this.copy(copy_buffer, starting_id, (short[])null);
    }

    public Message copy(boolean copy_buffer, short starting_id, short ... copy_only_ids) {
        Message retval = this.copy(copy_buffer, false);
        for (Map.Entry<Short, Header> entry : this.getHeaders().entrySet()) {
            short id = entry.getKey();
            if (id < starting_id && !Util.containsId(id, copy_only_ids)) continue;
            retval.putHeader(id, entry.getValue());
        }
        return retval;
    }

    public Message makeReply() {
        Message retval = new Message(this.src_addr);
        if (this.dest_addr != null) {
            retval.setSrc(this.dest_addr);
        }
        return retval;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        int size = this.getNumHeaders();
        if (size > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size=");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        if (this.flags > 0) {
            ret.append(", flags=").append(Message.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            ret.append(", transient_flags=" + this.transientFlagsToString());
        }
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String printObjectHeaders() {
        return this.headers.printObjectHeaders();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        byte leading = 0;
        if (this.dest_addr != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.src_addr != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (this.dest_addr != null) {
            Util.writeAddress(this.dest_addr, out);
        }
        if (this.src_addr != null) {
            Util.writeAddress(this.src_addr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] <= 0) continue;
            out.writeShort(ids[i]);
            Message.writeHeader(hdrs[i], out);
        }
    }

    public void writeToNoAddrs(Address src, DataOutputStream out, short ... excluded_headers) throws Exception {
        boolean write_src_addr;
        byte leading = 0;
        boolean bl = write_src_addr = src == null || this.src_addr != null && !this.src_addr.equals(src);
        if (write_src_addr) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (write_src_addr) {
            Util.writeAddress(this.src_addr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size(excluded_headers);
        out.writeShort(size);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] <= 0 || excluded_headers != null && Util.containsId(ids[i], excluded_headers)) continue;
            out.writeShort(ids[i]);
            Message.writeHeader(hdrs[i], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        int len;
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.src_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)4)) {
            len = in.readInt();
            this.buf = new byte[len];
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = Message.createHeaders(len);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < len; ++i) {
            short id = in.readShort();
            Header hdr = Message.readHeader(in);
            ids[i] = id;
            hdrs[i] = hdr;
        }
    }

    public long size() {
        long retval = 3L;
        if (this.dest_addr != null) {
            retval += (long)Util.size(this.dest_addr);
        }
        if (this.src_addr != null) {
            retval += (long)Util.size(this.src_addr);
        }
        if (this.buf != null) {
            retval += (long)(4 + this.length);
        }
        retval += 2L;
        return retval += (long)this.headers.marshalledSize();
    }

    public static String flagsToString(short flags) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (Message.isFlagSet(flags, Flag.OOB)) {
            first = false;
            sb.append("OOB");
        }
        if (Message.isFlagSet(flags, Flag.DONT_BUNDLE)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("DONT_BUNDLE");
        }
        if (Message.isFlagSet(flags, Flag.NO_FC)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_FC");
        }
        if (Message.isFlagSet(flags, Flag.SCOPED)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("SCOPED");
        }
        if (Message.isFlagSet(flags, Flag.NO_RELIABILITY)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_RELIABILITY");
        }
        if (Message.isFlagSet(flags, Flag.NO_TOTAL_ORDER)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_TOTAL_ORDER");
        }
        if (Message.isFlagSet(flags, Flag.NO_RELAY)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_RELAY");
        }
        if (Message.isFlagSet(flags, Flag.RSVP)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("RSVP");
        }
        return sb.toString();
    }

    public String transientFlagsToString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTransientFlagSet(TransientFlag.OOB_DELIVERED)) {
            sb.append("OOB_DELIVERED");
        }
        return sb.toString();
    }

    protected static void writeHeader(Header hdr, DataOutput out) throws Exception {
        short magic_number = ClassConfigurator.getMagicNumber(hdr.getClass());
        out.writeShort(magic_number);
        hdr.writeTo(out);
    }

    protected static Header readHeader(DataInput in) throws Exception {
        short magic_number = in.readShort();
        Class<?> clazz = ClassConfigurator.get(magic_number);
        if (clazz == null) {
            throw new IllegalArgumentException("magic number " + magic_number + " is not available in magic map");
        }
        Header hdr = (Header)clazz.newInstance();
        hdr.readFrom(in);
        return hdr;
    }

    protected static Headers createHeaders(int size) {
        return size > 0 ? new Headers(size) : new Headers(3);
    }

    protected static Headers createHeaders(Headers m) {
        return new Headers(m);
    }

    public static enum TransientFlag {
        OOB_DELIVERED(1);

        final short value;

        private TransientFlag(short flag) {
            this.value = flag;
        }

        public short value() {
            return this.value;
        }
    }

    public static enum Flag {
        OOB(1),
        DONT_BUNDLE(2),
        NO_FC(4),
        SCOPED(8),
        NO_RELIABILITY(16),
        NO_TOTAL_ORDER(32),
        NO_RELAY(64),
        RSVP(128);

        final short value;

        private Flag(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }
    }
}

