/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class ResourceDMBean
implements DynamicMBean {
    protected static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    protected static final String MBEAN_DESCRITION = "MBeanDescription";
    protected static final List<Method> OBJECT_METHODS = new ArrayList<Method>(Arrays.asList(Object.class.getMethods()));
    protected final boolean expose_all;
    protected final Log log = LogFactory.getLog(ResourceDMBean.class);
    protected final Object obj;
    protected final MBeanAttributeInfo[] attrInfo;
    protected final MBeanOperationInfo[] opInfo;
    protected final HashMap<String, AttributeEntry> atts = new HashMap();
    protected final List<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();

    public ResourceDMBean(Object instance) {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        Class<?> c = this.obj.getClass();
        this.expose_all = c.isAnnotationPresent(MBean.class) && c.getAnnotation(MBean.class).exposeAll();
        this.findFields();
        this.findMethods();
        this.fixFields();
        this.attrInfo = new MBeanAttributeInfo[this.atts.size()];
        int i = 0;
        MBeanAttributeInfo info = null;
        for (AttributeEntry entry : this.atts.values()) {
            info = entry.info;
            this.attrInfo[i++] = info;
        }
        this.opInfo = new MBeanOperationInfo[this.ops.size()];
        this.ops.toArray(this.opInfo);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.obj.getClass().getCanonicalName(), "DynamicMBean", this.attrInfo, null, this.opInfo, null);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            this.log.warn("Did not find attribute " + name);
        }
        return al;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            if (this.setNamedAttribute(attr)) {
                results.add(attr);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("Failed to update attribute name " + attr.getName() + " with value " + attr.getValue());
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ResourceDMBean.getClassForName(sig[i]);
            }
            Method method = this.obj.getClass().getMethod(name, classes);
            return method.invoke(this.obj, args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public static boolean isSetMethod(Method method) {
        return method.getParameterTypes().length == 1;
    }

    public static boolean isGetMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static boolean isIsMethod(Method method) {
        return method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class);
    }

    protected static Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    protected void findMethods() {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.obj.getClass().getMethods()));
        methods.removeAll(OBJECT_METHODS);
        for (Method method : methods) {
            if (method.isAnnotationPresent(ManagedAttribute.class) || method.isAnnotationPresent(Property.class)) {
                this.exposeManagedAttribute(method);
                continue;
            }
            if (!method.isAnnotationPresent(ManagedOperation.class) && !this.expose_all) continue;
            ManagedOperation op = method.getAnnotation(ManagedOperation.class);
            this.ops.add(new MBeanOperationInfo(op != null ? op.description() : "", method));
        }
    }

    protected void fixFields() {
        for (AttributeEntry attr : this.atts.values()) {
            if (attr.getter == null) {
                attr.getter = ResourceDMBean.findGetter(this.obj, attr.name);
            }
            if (attr.setter != null) continue;
            attr.setter = ResourceDMBean.findSetter(this.obj, attr.name);
        }
    }

    protected void exposeManagedAttribute(Method method) {
        String attr_name;
        boolean writable;
        boolean expose;
        String methodName = method.getName();
        ManagedAttribute attr_annotation = method.getAnnotation(ManagedAttribute.class);
        Property prop = method.getAnnotation(Property.class);
        boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
        boolean bl = expose = attr_annotation != null || expose_prop;
        if (!expose) {
            return;
        }
        boolean bl2 = writable = prop != null && prop.writable() || attr_annotation != null && attr_annotation.writable();
        String string = attr_annotation != null ? attr_annotation.name() : (attr_name = prop != null ? prop.name() : null);
        if (attr_name != null && !attr_name.trim().isEmpty()) {
            attr_name = attr_name.trim();
        } else {
            String tmp;
            attr_name = Util.methodNameToAttributeName(methodName);
            if (!this.atts.containsKey(attr_name) && this.atts.containsKey(tmp = Util.methodNameToJavaAttributeName(methodName))) {
                attr_name = tmp;
            }
        }
        String descr = attr_annotation != null ? attr_annotation.description() : (prop != null ? prop.description() : null);
        AttributeEntry attr = this.atts.get(attr_name);
        if (attr != null) {
            if (ResourceDMBean.isSetMethod(method)) {
                if (attr.setter != null) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("setter for \"" + attr_name + "\" is already defined (new method=" + method.getName() + ")");
                    }
                } else {
                    attr.setter = new MethodAccessor(method, this.obj);
                }
            } else if (attr.getter != null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("getter for \"" + attr_name + "\" is already defined (new method=" + method.getName() + ")");
                }
            } else {
                attr.getter = new MethodAccessor(method, this.obj);
            }
        } else {
            boolean is_setter = ResourceDMBean.isSetMethod(method);
            String type = is_setter ? method.getParameterTypes()[0].getCanonicalName() : method.getReturnType().getCanonicalName();
            MBeanAttributeInfo info = new MBeanAttributeInfo(attr_name, type, descr, true, writable, methodName.startsWith("is"));
            AttributeEntry entry = new AttributeEntry(Util.methodNameToAttributeName(methodName), info);
            if (is_setter) {
                entry.setter(new MethodAccessor(method, this.obj));
            } else {
                entry.getter(new MethodAccessor(method, this.obj));
            }
            this.atts.put(attr_name, entry);
        }
    }

    protected static Accessor findGetter(Object target, String attr_name) {
        String name = Util.attributeNameToMethodName(attr_name);
        Class<?> clazz = target.getClass();
        Method method = Util.findMethod(target, Arrays.asList("get" + name, "is" + name, ResourceDMBean.toLowerCase(name)), new Class[0]);
        if (method != null && (ResourceDMBean.isGetMethod(method) || ResourceDMBean.isIsMethod(method))) {
            return new MethodAccessor(method, target);
        }
        Field field = Util.getField(clazz, attr_name);
        if (field != null) {
            return new FieldAccessor(field, target);
        }
        return new NoopAccessor();
    }

    protected static Accessor findSetter(Object target, String attr_name) {
        Method method;
        String name = Util.attributeNameToMethodName(attr_name);
        String fluent_name = ResourceDMBean.toLowerCase(name);
        Class<?> clazz = target.getClass();
        Class<?> field_type = null;
        Field field = Util.getField(clazz, attr_name);
        Class<?> clazz2 = field_type = field != null ? field.getType() : null;
        if (field_type != null && (method = Util.findMethod(target, Arrays.asList(fluent_name, "set" + name), field_type)) != null && ResourceDMBean.isSetMethod(method)) {
            return new MethodAccessor(method, target);
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
        methods.removeAll(OBJECT_METHODS);
        for (Method method2 : methods) {
            String method_name = method2.getName();
            if (!method_name.equals(name) && !method_name.equals(fluent_name) || !ResourceDMBean.isSetMethod(method2)) continue;
            return new MethodAccessor(method2, target);
        }
        if (field != null) {
            return new FieldAccessor(field, target);
        }
        return new NoopAccessor();
    }

    protected static String toLowerCase(String input) {
        if (Character.isUpperCase(input.charAt(0))) {
            return input.substring(0, 1).toLowerCase() + input.substring(1);
        }
        return input;
    }

    protected void findFields() {
        for (Class<?> clazz = this.obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName;
                boolean expose;
                ManagedAttribute attr = field.getAnnotation(ManagedAttribute.class);
                Property prop = field.getAnnotation(Property.class);
                boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
                boolean bl = expose = attr != null || expose_prop;
                if (!expose) continue;
                String string = attr != null ? attr.name() : (fieldName = prop != null ? prop.name() : null);
                if (fieldName != null && fieldName.trim().isEmpty()) {
                    fieldName = field.getName();
                }
                String descr = attr != null ? attr.description() : prop.description();
                boolean writable = attr != null ? attr.writable() : prop.writable();
                MBeanAttributeInfo info = new MBeanAttributeInfo(fieldName, field.getType().getCanonicalName(), descr, true, !Modifier.isFinal(field.getModifiers()) && writable, false);
                this.atts.put(fieldName, new AttributeEntry(field.getName(), info));
            }
        }
    }

    protected Attribute getNamedAttribute(String name) {
        AttributeEntry entry = this.atts.get(name);
        if (entry != null) {
            try {
                return new Attribute(name, entry.getter.invoke(null));
            }
            catch (Exception e) {
                this.log.warn(Util.getMessage("AttrReadFailure", name, e));
            }
        } else {
            this.log.warn(Util.getMessage("MissingAttribute", name));
        }
        return null;
    }

    protected boolean setNamedAttribute(Attribute attribute) {
        AttributeEntry entry = this.atts.get(attribute.getName());
        if (entry != null) {
            try {
                entry.setter.invoke(attribute.getValue());
                return true;
            }
            catch (Throwable e) {
                this.log.warn(Util.getMessage("AttrWriteFailure", attribute.getName(), e));
            }
        } else {
            this.log.warn(Util.getMessage("MissingAttribute", attribute.getName()));
        }
        return false;
    }

    protected static class NoopAccessor
    implements Accessor {
        protected NoopAccessor() {
        }

        @Override
        public Object invoke(Object new_val) throws Exception {
            return null;
        }

        public String toString() {
            return "NoopAccessor";
        }
    }

    protected static class FieldAccessor
    implements Accessor {
        protected final Field field;
        protected final Object target;

        public FieldAccessor(Field field, Object target) {
            this.field = field;
            this.target = target;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        @Override
        public Object invoke(Object new_val) throws Exception {
            if (new_val == null) {
                return this.field.get(this.target);
            }
            this.field.set(this.target, new_val);
            return null;
        }

        public String toString() {
            return "field[" + this.field.getName() + "]";
        }
    }

    protected static class MethodAccessor
    implements Accessor {
        protected final Method method;
        protected final Object target;

        public MethodAccessor(Method method, Object target) {
            this.method = method;
            this.target = target;
        }

        @Override
        public Object invoke(Object new_val) throws Exception {
            return new_val != null ? this.method.invoke(this.target, new_val) : this.method.invoke(this.target, new Object[0]);
        }

        public String toString() {
            return this.method.getName() + "()";
        }
    }

    protected static interface Accessor {
        public Object invoke(Object var1) throws Exception;
    }

    protected static class AttributeEntry {
        protected final String name;
        protected final MBeanAttributeInfo info;
        protected Accessor getter;
        protected Accessor setter;

        protected AttributeEntry(String name, MBeanAttributeInfo info) {
            this(name, info, null, null);
        }

        protected AttributeEntry(String name, MBeanAttributeInfo info, Accessor getter, Accessor setter) {
            this.name = name;
            this.info = info;
            this.getter = getter;
            this.setter = setter;
        }

        protected Accessor getter() {
            return this.getter;
        }

        protected AttributeEntry getter(Accessor new_getter) {
            this.getter = new_getter;
            return this;
        }

        protected Accessor setter() {
            return this.setter;
        }

        protected AttributeEntry setter(Accessor new_setter) {
            this.setter = new_setter;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AttributeEntry[" + this.name);
            if (this.getter != null) {
                sb.append(", getter=" + this.getter);
            }
            if (this.setter() != null) {
                sb.append(", setter=" + this.setter);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

