/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class PingData
implements SizeStreamable {
    protected Address sender = null;
    protected View view = null;
    protected ViewId view_id = null;
    protected boolean is_server = false;
    protected String logical_name = null;
    protected Collection<PhysicalAddress> physical_addrs = null;

    public PingData() {
    }

    public PingData(Address sender, View view, boolean is_server) {
        this.sender = sender;
        this.view = view;
        this.is_server = is_server;
    }

    public PingData(Address sender, View view, boolean is_server, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        this(sender, view, is_server);
        this.logical_name = logical_name;
        if (physical_addrs != null) {
            this.physical_addrs = new ArrayList<PhysicalAddress>(physical_addrs);
        }
    }

    public PingData(Address sender, View view, ViewId view_id, boolean is_server, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        this(sender, view, is_server, logical_name, physical_addrs);
        this.view_id = view_id;
    }

    public boolean isCoord() {
        Address coord_addr = this.getCoordAddress();
        return this.is_server && this.sender != null && coord_addr != null && this.sender.equals(coord_addr);
    }

    public boolean hasCoord() {
        Address coord_addr = this.getCoordAddress();
        return this.is_server && this.sender != null && coord_addr != null;
    }

    public Address getAddress() {
        return this.sender;
    }

    public Address getCoordAddress() {
        if (this.view_id != null) {
            return this.view_id.getCreator();
        }
        return this.view != null ? this.view.getVid().getCreator() : null;
    }

    public Collection<Address> getMembers() {
        return this.view != null ? this.view.getMembers() : null;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public ViewId getViewId() {
        return this.view_id;
    }

    public void setViewId(ViewId view_id) {
        this.view_id = view_id;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public Collection<PhysicalAddress> getPhysicalAddrs() {
        return this.physical_addrs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PingData)) {
            return false;
        }
        PingData other = (PingData)obj;
        return this.sender != null && this.sender.equals(other.sender);
    }

    public int hashCode() {
        int retval = 0;
        if (this.sender != null) {
            retval += this.sender.hashCode();
        }
        if (retval == 0) {
            retval = super.hashCode();
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sender);
        sb.append(", " + this.printViewId());
        sb.append(", is_server=").append(this.is_server).append(", is_coord=" + this.isCoord());
        if (this.logical_name != null) {
            sb.append(", logical_name=").append(this.logical_name);
        }
        if (this.physical_addrs != null && !this.physical_addrs.isEmpty()) {
            sb.append(", physical_addrs=").append(Util.printListWithDelimiter(this.physical_addrs, ", "));
        }
        return sb.toString();
    }

    public String printViewId() {
        StringBuilder sb = new StringBuilder();
        sb.append("view_id=");
        if (this.view_id != null) {
            sb.append(this.view_id);
        } else if (this.view != null) {
            sb.append(this.view.getViewId()).append(" (");
            if (this.view.size() > 10) {
                sb.append(this.view.size() + " mbrs");
            } else {
                sb.append(this.view);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput outstream) throws Exception {
        Util.writeAddress(this.sender, outstream);
        Util.writeView(this.view, outstream);
        Util.writeViewId(this.view_id, outstream);
        outstream.writeBoolean(this.is_server);
        Util.writeString(this.logical_name, outstream);
        Util.writeAddresses(this.physical_addrs, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws Exception {
        this.sender = Util.readAddress(instream);
        this.view = Util.readView(instream);
        this.view_id = Util.readViewId(instream);
        this.is_server = instream.readBoolean();
        this.logical_name = Util.readString(instream);
        this.physical_addrs = Util.readAddresses(instream, ArrayList.class);
    }

    @Override
    public int size() {
        int retval = 1;
        retval += Util.size(this.sender);
        retval += Util.size(this.view);
        retval += Util.size(this.view_id);
        ++retval;
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval = (int)((long)retval + Util.size(this.physical_addrs));
        return retval;
    }
}

