/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;

@Experimental
public class SHUFFLE
extends Protocol {
    protected TimeScheduler timer = null;
    protected final List<Message> up_msgs = new LinkedList<Message>();
    protected final List<Message> down_msgs = new LinkedList<Message>();
    protected Future<?> task = null;
    @Property
    protected boolean up = true;
    @Property
    protected boolean down = false;
    @Property(description="max number of messages before we bundle")
    protected int max_size = 10;
    @Property(description="max time (ms) before we pass the bundled messages up or down")
    protected long max_time = 1500L;

    public boolean isUp() {
        return this.up;
    }

    public void setUp(boolean up2) {
        this.up = up2;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down2) {
        this.down = down2;
    }

    public int getMaxSize() {
        return this.max_size;
    }

    public void setMaxSize(int max_size) {
        this.max_size = max_size;
    }

    public long getMaxTime() {
        return this.max_time;
    }

    public void setMaxTime(long max_time) {
        this.max_time = max_time;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        if (!this.up) {
            return this.up_prot.up(evt);
        }
        if (evt.getType() != 1) {
            return this.up_prot.up(evt);
        }
        Message msg = (Message)evt.getArg();
        List<Message> list = this.up_msgs;
        synchronized (list) {
            this.up_msgs.add(msg);
        }
        if (this.up_msgs.size() >= this.max_size) {
            this.shuffleAndSendMessages();
        } else {
            this.startTask();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        if (!this.up) {
            this.up_prot.up(batch);
            return;
        }
        List<Message> list = this.up_msgs;
        synchronized (list) {
            for (Message msg : batch) {
                if (msg == null) continue;
                this.up_msgs.add(msg);
            }
        }
        batch.removeAll();
        if (this.up_msgs.size() >= this.max_size) {
            this.shuffleAndSendMessages();
        } else {
            this.startTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        if (!this.down) {
            return this.down_prot.down(evt);
        }
        if (evt.getType() != 1) {
            return this.down_prot.down(evt);
        }
        Message msg = (Message)evt.getArg();
        List<Message> list = this.down_msgs;
        synchronized (list) {
            this.down_msgs.add(msg);
        }
        if (this.down_msgs.size() >= this.max_size) {
            this.shuffleAndSendMessages();
        } else {
            this.startTask();
        }
        return null;
    }

    protected synchronized void startTask() {
        if (this.task == null || this.task.isDone() || this.task.isCancelled()) {
            this.task = this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    SHUFFLE.this.shuffleAndSendMessages();
                }
            }, this.max_time, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopTask() {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shuffleAndSendMessages() {
        List<Message> list = this.up_msgs;
        synchronized (list) {
            if (!this.up_msgs.isEmpty()) {
                Collections.shuffle(this.up_msgs);
                for (Message msg : this.up_msgs) {
                    this.up_prot.up(new Event(1, msg));
                }
                this.up_msgs.clear();
            }
        }
        list = this.down_msgs;
        synchronized (list) {
            if (!this.down_msgs.isEmpty()) {
                Collections.shuffle(this.down_msgs);
                for (Message msg : this.down_msgs) {
                    this.down_prot.down(new Event(1, msg));
                }
                this.down_msgs.clear();
            }
        }
    }
}

