/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    private final Promise<JoinRsp> join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.join_promise.reset();
    }

    @Override
    public void join(Address address, boolean useFlushIfPresent) {
        this.joinInternal(address, false, useFlushIfPresent);
    }

    @Override
    public void joinWithStateTransfer(Address local_addr, boolean useFlushIfPresent) {
        this.joinInternal(local_addr, true, useFlushIfPresent);
    }

    private void joinInternal(Address mbr, boolean joinWithStateTransfer, boolean useFlushIfPresent) {
        Address coord = null;
        JoinRsp rsp = null;
        long join_attempts = 0L;
        this.leaving = false;
        this.join_promise.reset();
        while (!this.leaving) {
            if (rsp == null && !this.join_promise.hasResult()) {
                List<PingData> responses = this.findInitialMembers(this.join_promise);
                if (responses == null) {
                    throw new NullPointerException("responses returned by findInitialMembers for " + this.join_promise + " is null");
                }
                if (this.join_promise.hasResult() && (rsp = this.join_promise.getResult(this.gms.join_timeout)) != null) continue;
                if (responses.isEmpty()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.gms.local_addr + ": no initial members discovered: creating group as first member");
                    }
                    this.becomeSingletonMember(mbr);
                    return;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.gms.local_addr + ": initial_mbrs are " + ClientGmsImpl.print(responses));
                }
                if ((coord = this.determineCoord(responses)) == null) {
                    Address new_coord;
                    if (!this.gms.handle_concurrent_startup) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("handle_concurrent_startup is false; ignoring responses of initial clients");
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("could not determine coordinator from responses " + responses);
                    }
                    TreeSet<Address> clients = new TreeSet<Address>();
                    clients.add(mbr);
                    for (PingData response : responses) {
                        Address client_addr = response.getAddress();
                        if (client_addr == null) continue;
                        clients.add(client_addr);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("clients to choose new coord from are: " + clients);
                    }
                    if ((new_coord = (Address)clients.first()).equals(mbr)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("I (" + mbr + ") am the first of the clients, will become coordinator");
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("I (" + mbr + ") am not the first of the clients, waiting for another client to become coordinator");
                    }
                    Util.sleep(500L);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sending JOIN(" + mbr + ") to " + coord);
                }
                this.sendJoinMessage(coord, mbr, joinWithStateTransfer, useFlushIfPresent);
            }
            if (rsp == null) {
                rsp = this.join_promise.getResult(this.gms.join_timeout);
            }
            if (rsp == null) {
                ++join_attempts;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("JOIN(" + mbr + ") sent to " + coord + " timed out (after " + this.gms.join_timeout + " ms), on try " + join_attempts);
                }
                if (this.gms.max_join_attempts == 0L || join_attempts < this.gms.max_join_attempts) continue;
                if (this.log.isWarnEnabled()) {
                    this.log.warn("Too many JOIN attempts: becoming singleton");
                }
                this.becomeSingletonMember(mbr);
                return;
            }
            String failure = rsp.getFailReason();
            if (failure != null) {
                throw new SecurityException(failure);
            }
            if (rsp.getDigest() == null || rsp.getDigest().size() == 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("digest response has no senders: digest=" + rsp.getDigest());
                }
                rsp = null;
                continue;
            }
            Digest tmp_digest = rsp.getDigest();
            View tmp_view = rsp.getView();
            if (tmp_view == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("JoinRsp has a null view, skipping it");
                }
                rsp = null;
                continue;
            }
            if (!tmp_digest.contains(this.gms.local_addr)) {
                throw new IllegalStateException("digest returned from " + coord + " with JOIN_RSP does not contain myself (" + this.gms.local_addr + "): join response: " + rsp);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": JOIN-RSP=" + tmp_view + " [size=" + tmp_view.size() + "]\n\n");
            }
            if (!this.installView(tmp_view, tmp_digest)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("view installation failed, retrying to join group");
                }
                rsp = null;
                continue;
            }
            Message view_ack = new Message(coord).setFlag(Message.OOB).putHeader(this.gms.getId(), new GMS.GmsHeader(10));
            this.gms.getDownProtocol().down(new Event(1, view_ack));
            return;
        }
    }

    private List<PingData> findInitialMembers(Promise<JoinRsp> promise) {
        List responses = (List)this.gms.getDownProtocol().down(new Event(12, promise));
        if (responses != null) {
            Iterator iter = responses.iterator();
            while (iter.hasNext()) {
                Address address = ((PingData)iter.next()).getAddress();
                if (address == null || !address.equals(this.gms.local_addr)) continue;
                iter.remove();
            }
        }
        return responses;
    }

    @Override
    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    private boolean installView(View new_view, Digest digest) {
        List<Address> mems = new_view.getMembers();
        if (this.gms.local_addr == null || mems == null || !mems.contains(this.gms.local_addr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("I (" + this.gms.local_addr + ") am not member of " + mems + ", will not install view");
            }
            return false;
        }
        this.gms.installView(new_view, digest);
        this.gms.becomeParticipant();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        return true;
    }

    protected static String print(List<PingData> rsps) {
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : rsps) {
            sb.append(rsp.getAddress() + " ");
        }
        return sb.toString();
    }

    void sendJoinMessage(Address coord, Address mbr, boolean joinWithTransfer, boolean useFlushIfPresent) {
        Message msg = new Message(coord, null, null);
        msg.setFlag(Message.OOB);
        GMS.GmsHeader hdr = joinWithTransfer ? new GMS.GmsHeader(11, mbr, useFlushIfPresent) : new GMS.GmsHeader(1, mbr, useFlushIfPresent);
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private Address determineCoord(List<PingData> mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        HashMap<Address, Integer> votes = new HashMap<Address, Integer>(5);
        for (PingData pingData : mbrs) {
            if (!pingData.hasCoord()) continue;
            if (!votes.containsKey(pingData.getCoordAddress())) {
                votes.put(pingData.getCoordAddress(), 1);
                continue;
            }
            count = (Integer)votes.get(pingData.getCoordAddress());
            votes.put(pingData.getCoordAddress(), count + 1);
        }
        for (PingData pingData : mbrs) {
            if (!votes.containsKey(pingData.getAddress()) || pingData.isCoord()) continue;
            votes.remove(pingData.getAddress());
        }
        if (votes.size() > 1) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("there was more than 1 candidate for coordinator: " + votes);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("election results: " + votes);
        }
        int most_votes = 0;
        for (Map.Entry entry : votes.entrySet()) {
            Address tmp = (Address)entry.getKey();
            count = (Integer)entry.getValue();
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        ArrayList<Address> mbrs = new ArrayList<Address>(1);
        Digest initial_digest = new Digest(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        ViewId view_id = new ViewId(mbr);
        mbrs.add(mbr);
        View new_view = new View(view_id, mbrs);
        this.gms.installView(new_view);
        this.gms.becomeCoordinator();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        if (this.log.isDebugEnabled()) {
            this.log.debug("created group (first member). My view is " + this.gms.getViewId() + ", impl is " + this.gms.getImpl().getClass().getName());
        }
    }
}

