/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jgroups.Address;
import org.jgroups.Message;

public class MessageBatch
implements Iterable<Message> {
    protected Address dest;
    protected Address sender;
    protected String cluster_name;
    protected Message[] messages;
    protected int index;
    protected boolean multicast;
    protected Mode mode;
    protected static final int INCR = 5;

    public MessageBatch(int capacity) {
        this.messages = new Message[capacity];
    }

    public MessageBatch(Collection<Message> msgs) {
        this.messages = new Message[msgs.size()];
        for (Message msg : msgs) {
            this.messages[this.index++] = msg;
        }
    }

    public MessageBatch(Address dest, Address sender, String cluster_name, boolean multicast, Mode mode, int capacity) {
        this(capacity);
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = mode;
    }

    public Address dest() {
        return this.dest;
    }

    public MessageBatch dest(Address dest) {
        this.dest = dest;
        return this;
    }

    public Address sender() {
        return this.sender;
    }

    public MessageBatch sender(Address sender) {
        this.sender = sender;
        return this;
    }

    public String clusterName() {
        return this.cluster_name;
    }

    public MessageBatch clusterName(String name) {
        this.cluster_name = name;
        return this;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public Mode mode() {
        return this.mode;
    }

    public int capacity() {
        return this.messages.length;
    }

    public Message get(int index) {
        if (index >= 0 && index < this.messages.length) {
            return this.messages[index];
        }
        return null;
    }

    public MessageBatch set(int index, Message msg) {
        if (index >= 0 && index < this.messages.length) {
            this.messages[index] = msg;
        }
        return this;
    }

    public MessageBatch add(Message msg) {
        if (msg == null) {
            return this;
        }
        if (this.index >= this.messages.length) {
            this.resize();
        }
        this.messages[this.index++] = msg;
        return this;
    }

    public MessageBatch remove(int index) {
        if (index >= 0 && index < this.messages.length) {
            this.messages[index] = null;
        }
        return this;
    }

    public MessageBatch removeAll() {
        for (int i = 0; i < this.messages.length; ++i) {
            this.messages[i] = null;
        }
        this.index = 0;
        return this;
    }

    public Collection<Message> getMatchingMessages(final short id, final boolean remove) {
        return this.map(new Visitor<Message>(){

            @Override
            public Message visit(int index, Message msg, MessageBatch batch) {
                if (msg != null && msg.getHeader(id) != null) {
                    if (remove) {
                        batch.remove(index);
                    }
                    return msg;
                }
                return null;
            }
        });
    }

    public <T> Collection<T> map(Visitor<T> visitor) {
        ArrayList<T> retval = null;
        for (int i = 0; i < this.messages.length; ++i) {
            T result = visitor.visit(i, this.messages[i], this);
            if (result == null) continue;
            if (retval == null) {
                retval = new ArrayList<T>();
            }
            retval.add(result);
        }
        return retval;
    }

    public int size() {
        int retval = 0;
        Visitor<Integer> visitor = new Visitor<Integer>(){

            @Override
            public Integer visit(int index, Message msg, MessageBatch batch) {
                return msg != null ? 1 : 0;
            }
        };
        for (int i = 0; i < this.messages.length; ++i) {
            retval += ((Integer)visitor.visit(i, this.messages[i], this)).intValue();
        }
        return retval;
    }

    public boolean isEmpty() {
        for (Message msg : this.messages) {
            if (msg == null) continue;
            return false;
        }
        return true;
    }

    public long totalSize() {
        long retval = 0L;
        Visitor<Long> visitor = new Visitor<Long>(){

            @Override
            public Long visit(int index, Message msg, MessageBatch batch) {
                return msg != null ? msg.size() : 0L;
            }
        };
        for (int i = 0; i < this.messages.length; ++i) {
            retval += ((Long)visitor.visit(i, this.messages[i], this)).longValue();
        }
        return retval;
    }

    public int length() {
        int retval = 0;
        Visitor<Integer> visitor = new Visitor<Integer>(){

            @Override
            public Integer visit(int index, Message msg, MessageBatch batch) {
                return msg != null ? msg.getLength() : 0;
            }
        };
        for (int i = 0; i < this.messages.length; ++i) {
            retval += ((Integer)visitor.visit(i, this.messages[i], this)).intValue();
        }
        return retval;
    }

    @Override
    public Iterator<Message> iterator() {
        return new BatchIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(this.size() + " messages [capacity=" + this.messages.length + "]");
        return sb.toString();
    }

    protected void resize() {
        Message[] tmp = new Message[this.messages.length + 5];
        System.arraycopy(this.messages, 0, tmp, 0, this.messages.length);
        this.messages = tmp;
    }

    protected class BatchIterator
    implements Iterator<Message> {
        protected int current_index = -1;

        protected BatchIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current_index + 1 < MessageBatch.this.messages.length;
        }

        @Override
        public Message next() {
            if (this.current_index + 1 >= MessageBatch.this.messages.length) {
                throw new NoSuchElementException();
            }
            return MessageBatch.this.messages[++this.current_index];
        }

        @Override
        public void remove() {
            if (this.current_index >= 0) {
                MessageBatch.this.remove(this.current_index);
            }
        }
    }

    public static enum Mode {
        OOB,
        REG,
        MIXED;

    }

    public static interface Visitor<T> {
        public T visit(int var1, Message var2, MessageBatch var3);
    }
}

