(ns om.next.spec
  (:require #?(:clj  [clojure.spec :as s]
               :cljs [cljs.spec :as s])
            [clojure.test.check :as tc]
            [clojure.test.check.properties :as tcp]))

;; -----------------------------------------------------------------------------
;; Query

(s/def ::ident
  (s/and vector?
    (s/cat :ident keyword?
           :value #(not (coll? %)))))

(s/def ::join-key
  (s/or :prop keyword?
        :ident ::ident))

(s/def ::recursion
  (s/or :depth number?
        :unbounded '#{...}))

(s/def ::join
  (s/and
    (s/map-of ::join-key
      (s/or :query ::query
            :recursion ::recursion))
    #(= (count %) 1)))

(s/def ::union
  (s/and (s/map-of keyword? ::query)
    #(> (count %) 1)))

(s/def ::param-expr
  (s/cat :query-expr ::query-expr
         :params map?))

(s/def ::mutation-expr
  (s/or :no-params   (s/cat :mutate-key symbol?)
        :with-params (s/cat :mutate-key symbol?
                            :params map?)))

(s/def ::query-expr
  (s/or :prop keyword?
        :ident ::ident
        :mutation-expr ::mutation-expr
        :union ::union
        :param-expr ::join))

(s/def ::query (s/and vector? (s/+ ::query-expr)))

(comment

  (s/conform ::query '[:foo 0])

  (s/explain ::query '[:foo {:bar [:baz :woz 1]}])

  (s/explain ::query [{:bar [:baz :woz 1]}])

  (s/explain ::query [{:bar '...}])

  )

;; -----------------------------------------------------------------------------
;; defui

(s/def ::static-protocol
  '#{om.next/Ident om.next/IQuery om.next/IQueryParams})

(s/def ::static
  (s/cat
    :static '#{static}
    :protocol-name ::static-protocol
    :methods (s/* seq?)))

(s/def ::non-static-protocol
  (s/and symbol? #(not ('#{static om.next/Ident om.next/IQuery om.next/IQueryParams} %))))

(s/def ::protocol
  (s/alt
    :protocol (s/cat
                 :protocol-name ::non-static-protocol
                 :methods (s/+ seq?))
    :marker-protocol (s/cat :protocol-name ::non-static-protocol)))

(s/def ::methods
  (s/* (s/alt :static ::static
              :protocol ::protocol)))

(s/def ::defui
  (s/cat :name  symbol?
         :impls ::methods))


(comment
  (require '[clojure.test.check])

  (s/exercise ::let 10)

  (s/conform ::non-static-protocol 'Object)
  (s/conform ::non-static-protocol 'static)
  (s/conform ::non-static-protocol 'om.next/Ident)
  (s/conform ::static-protocol 'om.next/Ident)

  (s/conform
    ::defui
    '(defui Foo))

  (s/conform
    ::protocols
    '(Object
       (render [this]
         )))

  (s/conform
    ::protocols
    '(Object))

  (s/conform
    ::methods
    '(Object
       (render [this]
         )))

  (s/explain
    ::methods
    '(Object
       (render [this]
         )))

  (s/conform
    ::defui
    '(defui Foo
       IFoo
       Object
       (render [this]
         )
       (shouldComponentUpdate [this next-props next-state])))

  (s/explain
    ::defui
    '(defui Foo
       Object
       (render [this]
         )))

  (s/conform
    ::defui
    '(defui Foo
       static om.next/Ident
       (ident [this props])
       Object
       (render [this]
         )
       (shouldComponentUpdate [this]
         )))

  (s/explain
    ::defui
    '(defui Foo
       static om.next/Ident
       (ident [this props])
       om.next/IQuery
       (query [this]
         [])
       Object
       (render [this]
         )
       (shouldComponentUpdate [this]
         )))

  (s/explain
    ::methods
    '(om.next/IQuery
       (query [this] [])
       Object
       (render [this])
       (shouldComponentUpdate [this])))

  (last (s/exercise ::defui 10))

  )