## onyx-core-s3

Onyx input plugin for S3. The input reader facilities read an input stream line by line, periodically checkpointing the latest acknowledged line. We don't yet have an output plugin for S3 since the only solutions that are apparent at the moment are lossy. Open a issue on GitHub for discussion on how we can write to S3 in a fault tolerant manner.

#### Installation

In your project file:

```clojure
[org.onyxplatform/onyx-s3 "0.6.0-RC1"]
```

In your peer boot-up namespace:

```clojure
(:require [onyx.plugin.s3])
```

#### Functions

##### read-s3-file

Catalog entry:

```clojure
{:onyx/name :read-s3-file
 :onyx/ident :s3/read-file
 :onyx/type :input
 :onyx/medium :s3
 :s3/access-key "my-access-key"
 :s3/secret-key "my-secret-key"
 :s3/bucket "my-bucket-name"
 :s3/key "my-file-name"
 :s3/decompress-fn :my.ns/decompression-fn-name
 :s3/chan-capacity 10000
 :s3/checkpoint-interval 5000
 :onyx/max-peers 1
 :onyx/batch-size batch-size
 :onyx/doc "Reads segments from S3"}
```

Lifecycle entry:

```clojure
[{:lifecycle/task :read-s3-file
  :lifecycle/calls :onyx.plugin.s3/reader-calls}]
```

#### Attributes

|key                      | type     | description
|-------------------------|----------|------------
|`:s3/access-key`         | `string` | AWS access key.
|`:s3/secret-key`         | `string` | AWS secret key.
|`:s3/bucket`             | `string` | AWS bucket name.
|`:s3/key`                | `string` | AWS file name inside the bucket.
|`:s3/decompress-fn`      | `keyword`| Keyword pointing to a fully namespaced qualified function that takes one argument, a string representing a line. Returns a segment.
|`:s3/chan-capacity`      | `integer`| Max number of segments to buffer before being read by Onyx. Default is 10000.
|`:s3/checkpoint-interval`| `int`    | Interval is milliseconds to checkpoint progress onto ZooKeeper. Default is 5000.

#### Contributing

Pull requests into the master branch are welcomed.

#### License

Copyright © 2015 Michael Drogalis

Distributed under the Eclipse Public License, the same as Clojure.
