(ns onyx.messaging.protocols.status-publisher)

(defprotocol PStatusPublisher
  (start [this])
  (stop [this])
  (info [this])
  (get-ticket [this])
  (get-short-circuit [this])
  (set-session-id! [this session-id ticket short-circuit])
  (get-session-id [this])
  (set-heartbeat! [this])
  (get-heartbeat [this])
  (get-short-id [this])
  (set-short-id! [this short-id])
  (block! [this])
  (unblock! [this])
  (blocked? [this])
  (set-completed! [this completed?])
  (completed? [this])
  (new-replica-version! [this])
  (offer-ready-reply! [this replica-version epoch]) 
  (offer-barrier-status! [this replica-version epoch opts]))
