/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.IteratorWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterIterator<E>
extends IteratorWrapper<E> {
    private E nextElement;

    public FilterIterator(Iterator<? extends E> iter) {
        super(iter);
    }

    @Override
    public boolean hasNext() {
        this.findNextElement();
        return this.nextElement != null;
    }

    @Override
    public E next() {
        this.findNextElement();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNextElement() {
        while (this.nextElement == null && super.hasNext()) {
            Object candidate = super.next();
            if (!this.accept(candidate)) continue;
            this.nextElement = candidate;
        }
    }

    protected abstract boolean accept(E var1);

    @Override
    protected void handleClose() {
        super.handleClose();
        this.nextElement = null;
    }
}

