/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.IteratorWrapper;
import info.aduna.concurrent.locks.Lock;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockingIterator<E>
extends IteratorWrapper<E> {
    private final Lock lock;

    public LockingIterator(Lock lock, Iterator<? extends E> iter) {
        super(iter);
        assert (lock != null);
        this.lock = lock;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (super.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public synchronized E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        return super.next();
    }

    @Override
    public synchronized void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        super.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() {
        try {
            super.handleClose();
        }
        finally {
            LockingIterator lockingIterator = this;
            synchronized (lockingIterator) {
                this.lock.release();
            }
        }
    }
}

