/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.FilterIterator;
import info.aduna.collections.iterators.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinusIterator<E>
extends FilterIterator<E> {
    private final Iterator<? extends E> rightArg;
    private final boolean distinct;
    private boolean initialized;
    private Set<E> excludeSet;

    public MinusIterator(Iterator<? extends E> leftArg, Iterator<? extends E> rightArg) {
        this(leftArg, rightArg, false);
    }

    public MinusIterator(Iterator<? extends E> leftArg, Iterator<? extends E> rightArg, boolean distinct) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(E object) {
        if (!this.initialized) {
            this.excludeSet = Iterators.addAll(this.rightArg, new HashSet());
            this.initialized = true;
        }
        if (!this.excludeSet.contains(object)) {
            if (this.distinct) {
                this.excludeSet.add(object);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleClose() {
        super.handleClose();
        Iterators.closeCloseable(this.rightArg);
    }
}

