/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeroLengthPath
extends QueryModelNodeBase
implements TupleExpr {
    private StatementPattern.Scope scope;
    private Var subjectVar;
    private Var objectVar;
    private Var contextVar;

    public ZeroLengthPath() {
    }

    public ZeroLengthPath(Var subject, Var object) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, object);
    }

    public ZeroLengthPath(StatementPattern.Scope scope, Var subject, Var object) {
        this(scope, subject, object, null);
    }

    public ZeroLengthPath(Var subject, Var object, Var context) {
        this(StatementPattern.Scope.DEFAULT_CONTEXTS, subject, object, context);
    }

    public ZeroLengthPath(StatementPattern.Scope scope, Var subjVar, Var objVar, Var conVar) {
        this.setScope(scope);
        this.setSubjectVar(subjVar);
        this.setObjectVar(objVar);
        this.setContextVar(conVar);
    }

    public StatementPattern.Scope getScope() {
        return this.scope;
    }

    public void setScope(StatementPattern.Scope scope) {
        assert (scope != null) : "scope must not be null";
        this.scope = scope;
    }

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public void setSubjectVar(Var subject) {
        assert (subject != null) : "subject must not be null";
        subject.setParentNode(this);
        this.subjectVar = subject;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public void setObjectVar(Var object) {
        assert (object != null) : "object must not be null";
        object.setParentNode(this);
        this.objectVar = object;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setContextVar(Var context) {
        if (context != null) {
            context.setParentNode(this);
        }
        this.contextVar = context;
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>(8);
        if (this.subjectVar != null) {
            bindingNames.add(this.subjectVar.getName());
        }
        if (this.objectVar != null) {
            bindingNames.add(this.objectVar.getName());
        }
        if (this.contextVar != null) {
            bindingNames.add(this.contextVar.getName());
        }
        return bindingNames;
    }

    public List<Var> getVarList() {
        return this.getVars(new ArrayList(4));
    }

    public <L extends Collection<Var>> L getVars(L varCollection) {
        if (this.subjectVar != null) {
            varCollection.add((Var)this.subjectVar);
        }
        if (this.objectVar != null) {
            varCollection.add((Var)this.objectVar);
        }
        if (this.contextVar != null) {
            varCollection.add((Var)this.contextVar);
        }
        return varCollection;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.contextVar != null) {
            this.contextVar.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            this.setSubjectVar((Var)replacement);
        } else if (this.objectVar == current) {
            this.setObjectVar((Var)replacement);
        } else if (this.contextVar == current) {
            this.setContextVar((Var)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            sb.append(" FROM NAMED CONTEXT");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ZeroLengthPath) {
            ZeroLengthPath o = (ZeroLengthPath)other;
            return this.subjectVar.equals(o.getSubjectVar()) && this.objectVar.equals(o.getObjectVar()) && this.nullEquals(this.contextVar, o.getContextVar()) && this.scope.equals((Object)o.getScope());
        }
        return false;
    }

    public int hashCode() {
        int result = this.subjectVar.hashCode();
        result ^= this.objectVar.hashCode();
        if (this.contextVar != null) {
            result ^= this.contextVar.hashCode();
        }
        if (this.scope == StatementPattern.Scope.NAMED_CONTEXTS) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public ZeroLengthPath clone() {
        ZeroLengthPath clone = (ZeroLengthPath)super.clone();
        clone.setSubjectVar(this.getSubjectVar().clone());
        clone.setObjectVar(this.getObjectVar().clone());
        if (this.getContextVar() != null) {
            clone.setContextVar(this.getContextVar().clone());
        }
        return clone;
    }
}

