/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphPattern {
    private Var contextVar;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private List<TupleExpr> requiredTEs = new ArrayList<TupleExpr>();
    private List<TupleExpr> optionalTEs = new ArrayList<TupleExpr>();
    private List<ValueExpr> constraints = new ArrayList<ValueExpr>();
    private List<Extension> assignments = new ArrayList<Extension>();

    public GraphPattern() {
    }

    public GraphPattern(GraphPattern parent) {
        this.contextVar = parent.contextVar;
        this.spScope = parent.spScope;
    }

    public void setContextVar(Var contextVar) {
        this.contextVar = contextVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        return this.spScope;
    }

    public void addRequiredTE(TupleExpr te) {
        this.requiredTEs.add(te);
    }

    public void addRequiredSP(Var subjVar, Var predVar, Var objVar) {
        this.addRequiredTE(new StatementPattern(this.spScope, subjVar, predVar, objVar, this.contextVar));
    }

    public List<TupleExpr> getRequiredTEs() {
        return Collections.unmodifiableList(this.requiredTEs);
    }

    public List<Extension> getBindingAssignments() {
        return Collections.unmodifiableList(this.assignments);
    }

    public void addOptionalTE(TupleExpr te) {
        this.optionalTEs.add(te);
    }

    public List<TupleExpr> getOptionalTEs() {
        return Collections.unmodifiableList(this.optionalTEs);
    }

    public void addConstraint(ValueExpr constraint) {
        this.constraints.add(constraint);
    }

    public void addBindingAssignment(Extension bindingAssignment) {
        this.assignments.add(bindingAssignment);
    }

    public void addConstraints(Collection<ValueExpr> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<ValueExpr> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public List<ValueExpr> removeAllConstraints() {
        List<ValueExpr> constraints = this.constraints;
        this.constraints = new ArrayList<ValueExpr>();
        return constraints;
    }

    public void clear() {
        this.requiredTEs.clear();
        this.optionalTEs.clear();
        this.constraints.clear();
    }

    public TupleExpr buildTupleExpr() {
        TupleExpr result;
        if (this.requiredTEs.isEmpty()) {
            result = new SingletonSet();
        } else {
            result = this.requiredTEs.get(0);
            for (int i = 1; i < this.requiredTEs.size(); ++i) {
                result = new Join(result, this.requiredTEs.get(i));
            }
        }
        for (TupleExpr optTE : this.optionalTEs) {
            result = new LeftJoin(result, optTE);
        }
        for (Extension assignment : this.assignments) {
            assignment.setArg(result);
            result = assignment;
        }
        for (ValueExpr constraint : this.constraints) {
            result = new Filter(result, constraint);
        }
        return result;
    }
}

