/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.common.sys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class PropertiesManager {
    protected File infoFile;
    protected Properties props;
    protected String propertiesTitle;

    public PropertiesManager() {
    }

    public PropertiesManager(File infoFile, String propertiesTitle) {
        this.infoFile = infoFile;
        this.props = new Properties();
        this.propertiesTitle = propertiesTitle;
        File parent = infoFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (infoFile.exists()) {
            this.loadData();
        } else {
            this.saveDefaultData();
        }
    }

    public PropertiesManager(String infoFilePath, String propertiesTitle) {
        this(new File(infoFilePath), propertiesTitle);
    }

    public PropertiesManager(File parentFolder, String fileName, String title) {
        this(new File(parentFolder, fileName), title);
    }

    private void loadData() {
        try {
            this.props.load(new FileInputStream(this.infoFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveData() {
        try {
            this.props.store(new FileOutputStream(this.infoFile), this.propertiesTitle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void restoreDefaultData() {
        this.props.clear();
        try {
            this.infoFile.createNewFile();
            this.props = new Properties();
            this.saveDefaultData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract void saveDefaultData();

    public boolean isKey(String key, String valueFilter) {
        String value = this.props.getProperty(key);
        return value != null && value.equals(valueFilter);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public int getNumericProperty(String key) {
        String strProps = this.getProperty(key);
        return strProps == null ? null : Integer.valueOf(Integer.parseInt(strProps));
    }

    public void setProperty(String key, String newValue) {
        this.props.setProperty(key, newValue);
        this.saveData();
    }

    public void setProperty(String key, Number newValue) {
        this.props.setProperty(key, newValue.toString());
        this.saveData();
    }

    public void addProperty(String key, String value) {
        this.setProperty(key, value);
    }

    public void addProperty(String key, Number value) {
        this.setProperty(key, value.toString());
    }
}

