/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.common.response;

import java.io.Serializable;

public class Song
implements Serializable {
    private String title;
    private String album;
    private String artist;
    private String date;
    private String progress;
    private String duration;
    private byte[] coverData;
    private int trackIndex;
    private static final long serialVersionUID = 106L;

    public Song() {
    }

    public Song(String title, String album, String artist, String date, long duration, byte[] coverData, int trackIndex) {
        this.title = title;
        this.album = album;
        this.artist = artist;
        this.date = date;
        this.duration = String.valueOf(duration);
        this.coverData = coverData;
        this.trackIndex = trackIndex;
    }

    public Song(String title, String album, String artist, String date, long duration, String coverData, int trackIndex) {
        this.title = title;
        this.album = album;
        this.artist = artist;
        this.date = date;
        this.duration = String.valueOf(duration);
        this.trackIndex = trackIndex;
        this.importCoverData(coverData);
    }

    public Song(String title, String album, String artist, String date, long duration, byte volume) {
        this(title, album, artist, date, duration, (String)null, -1);
    }

    public Song(String title, String album, String artist, String date, long duration, byte volume, int trackIndex) {
        this(title, album, artist, date, duration, (String)null, trackIndex);
    }

    private void importCoverData(String coverData) {
        if (coverData == null) {
            return;
        }
        char[] chars = coverData.toCharArray();
        this.coverData = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            this.coverData[i] = (byte)chars[i];
        }
    }

    public boolean hasCover() {
        return this.coverData != null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public byte[] getCoverData() {
        if (this.coverData == null) {
            return null;
        }
        return this.coverData;
    }

    public void setCoverData(byte[] coverData) {
        this.coverData = coverData;
    }

    public void setCoverData(String coverData) {
        this.importCoverData(coverData);
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public void setTrackIndex(int trackIndex) {
        this.trackIndex = trackIndex;
    }

    public String toString() {
        return "Song{title='" + this.title + '\'' + ", album='" + this.album + '\'' + ", artist='" + this.artist + '\'' + ", date='" + this.date + '\'' + ", progress='" + this.progress + '\'' + ", duration='" + this.duration + '\'' + ", coverData=" + this.coverData + '}';
    }
}

